% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_writeCSV.R
\name{monitor_writeCSV}
\alias{monitor_writeCSV}
\title{Write Monitor Data as CSV File}
\usage{
monitor_writeCSV(ws_monitor, saveFile = "ws_monitor.csv",
  metaOnly = FALSE, dataOnly = FALSE)
}
\arguments{
\item{ws_monitor}{\emph{ws_monitor} object}

\item{saveFile}{filename where CSV will be written}

\item{metaOnly}{flag specifying whether to use \code{ws_monitor$meta} for a machine parseable CSV}

\item{dataOnly}{flag specifying whether to use \code{ws_monitor$data} for a machine parseable CSV}
}
\description{
Writes the contents of the \code{ws_monitor} object as CSV file.
By default, the output is a "human readable" CSV that includes both \code{meta} and \code{data}.
This format is useful for point-and-click spreadsheet users who want to have 
everything on a single sheet.

To obtain machine parseable CSV files you can use \code{metaOnly} or \code{dataOnly} which are mutually
exclusive but which generate CSV files that can be automatically ingested.
}
\examples{
\dontrun{
data("Carmel_Valley")
Carmel_Valley <- monitor_subset(Carmel_Valley, tlim=c(20160802,20160803))
monitor_writeCSV(Carmel_Valley, 'CarmelValley.csv')
monitor_writeCSV(Carmel_Valley, 'CarmelValley_meta.csv', metaOnly = TRUE)
monitor_writeCSV(Carmel_Valley, 'CarmelValley_data.csv', dataOnly = TRUE)
}
}
\keyword{ws_monitor}
