% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skill_confusionMatrix.R
\name{skill_confusionMatrix}
\alias{skill_confusionMatrix}
\title{Confusion Matrix Statistics}
\usage{
skill_confusionMatrix(predicted, observed, FPCost = 1, FNCost = 1,
  lightweight = FALSE)
}
\arguments{
\item{predicted}{logical vector of predicted values}

\item{observed}{logical vector of observed values}

\item{FPCost}{cost associated with false positives (type I error)}

\item{FNCost}{cost associated with false negatives (type II error)}

\item{lightweight}{flag specifying creation of a return list without derived metrics}
}
\value{
List containing a table of \code{confusion matrix} values and a suite of derived metrics.
}
\description{
Measurements of categorical forecast accuracy have a long history
in weather forecasting. The standard approach involves making binary classifications
(detected/not-detected) of predicted and observed data and combining them in a
binary contingency table known as a \emph{confusion matrix}.

This function creates a \code{confusion matrix} from predicted and observed values and calculates
a wide range of common statistics including:
\itemize{
  \item{TP}{ (true postive)}
  \item{FP}{ (false postive) (type I error)}
  \item{FN}{ (false negative) (type II error)}
  \item{TN}{ (true negative) }
  \item{TPRate}{ (true positive rate) = sensitivity = recall = TP / (TP + FN)}
  \item{FPRate}{ (false positive rate) = FP / (FP + TN)}
  \item{FNRate}{ (false negative rate) = FN / (TP + FN)}
  \item{TNRate}{ (true negative rate) = specificity = TN / (FP + TN)}
  \item{accuracy}{ = proportionCorrect = (TP + TN) / total}
  \item{errorRate}{ = 1 - accuracy = (FP + FN) / total}
  \item{falseAlarmRatio}{ = PPV (positive predictive value) = precision = TP / (TP + FP)}
  \item{FDR}{ (false discovery rate) = FP / (TP + FP) }
  \item{NPV}{ (negative predictive value) = TN / (TN + FN)}
  \item{FOR}{ (false omission rate) = FN / (TN + FN)}
  \item{f1_score}{ = (2 * TP) / (2 * TP + FP + FN)}
  \item{detectionRate}{ = TP / total}
  \item{baseRate}{ = detectionPrevalence = (TP + FN) / total}
  \item{probForecastOccurance}{ = prevalence = (TP + FP) / total}
  \item{balancedAccuracy}{ = (TPRate + TNRate) / 2}
  \item{expectedAccuracy}{ = (((TP + FP) * (TP + FN) / total) + ((FP + TN) * sum(FN + TN) / total )) / total}
  \item{heidikeSkill}{ = kappa = (accuracy - expectedAccuracy) / (1 - expectedAccuracy)}
  \item{bias}{ = (TP + FP) / (TP + FN)}
  \item{hitRate}{ = TP / (TP + FN)}
  \item{falseAlarmRate}{ = FP / (FP + TN)}
  \item{pierceSkill}{ = ((TP * TN) - (FP * FN)) / ((FP + TN) * (TP + FN))}
  \item{criticalSuccess}{ = TP / (TP + FP + FN)}
  \item{oddsRatioSkill}{ = yulesQ = ((TP * TN) - (FP * FN)) / ((TP * TN) + (FP * FN))}
}
}
\examples{
predicted <- sample(c(TRUE,FALSE), 1000, replace=TRUE, prob=c(0.3,0.7))
observed <- sample(c(TRUE,FALSE), 1000, replace=TRUE, prob=c(0.3,0.7))
cm <- skill_confusionMatrix(predicted, observed)
print(cm)

}
\references{
\href{http://www.dataschool.io/simple-guide-to-confusion-matrix-terminology/}{Simple Guide to Confusion Matrix Terminology}
}
\seealso{
\link{skill_ROC}

\link{skill_ROCPlot}
}
