% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airnow_loadAnnual.R
\name{airnow_loadAnnual}
\alias{airnow_loadAnnual}
\title{Load annual AirNow monitoring data}
\usage{
airnow_loadAnnual(
  year = NULL,
  parameter = "PM2.5",
  baseUrl = "https://haze.airfire.org/monitoring",
  dataDir = NULL
)
}
\arguments{
\item{year}{Desired year (integer or character representing YYYY).}

\item{parameter}{Parameter of interest.}

\item{baseUrl}{Base URL for 'annual' AirNow data files.}

\item{dataDir}{Local directory containing 'annual' data files.}
}
\value{
A \emph{ws_monitor} object with AirNow data.
}
\description{
Loads pre-generated .RData files containing annual
AirNow data.

If \code{dataDir} is defined, data will be loaded from this local
dirctory. Otherwise, data will be loaded from the monitoring data repository
maintained by PWFSL.

The annual files loaded by this function are updated on the 15'th of each
month and cover the period from the beginning of the year to the end of the
last month.

For data during the last 45 days, use \code{airnow_loadDaily()}.

For the most recent data, use \code{airnow_loadLatest()}.

AirNow parameters include the following:
\enumerate{
\item{PM2.5}
}

Available AirNow RData and associated log files can be seen at:
\href{https://haze.airfire.org/monitoring/AirNow/RData}{https://haze.airfire.org/monitoring/AirNow/RData}
}
\examples{
\dontrun{
airnow_loadAnnual(2017) \%>\%
  monitor_subset(stateCodes='MT', tlim=c(20170701,20170930)) \%>\%
  monitor_dailyStatistic() \%>\%
  monitor_timeseriesPlot(style = 'gnats', ylim=c(0,300), xpd=NA)
  addAQIStackedBar()
  addAQILines()
  title("Montana 2017 -- AirNow Daily Average PM2.5")
}
}
\seealso{
\code{\link{airnow_loadDaily}}

\code{\link{airnow_loadLatest}}
}
\keyword{AirNow}
