% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_loadAnnual.R
\name{monitor_loadAnnual}
\alias{monitor_loadAnnual}
\title{Load annual PM2.5 monitoring data}
\usage{
monitor_loadAnnual(
  year = NULL,
  parameter = "PM2.5",
  baseUrl = "https://haze.airfire.org/monitoring",
  dataDir = NULL,
  aqsPreference = "airnow"
)
}
\arguments{
\item{year}{Desired year (integer or character representing YYYY).}

\item{parameter}{Parameter of interest.}

\item{baseUrl}{Base URL for data files.}

\item{dataDir}{Local directory containing 'daily' data files.}

\item{aqsPreference}{Preferred data source for AQS data when annual data
files are available from both `epa` and `airnow`.}
}
\value{
A \emph{ws_monitor} object with PM2.5 monitoring data.
}
\description{
Wrapper function to load and combine annual
data from AirNow, AIRSIS and WRCC.

If \code{dataDir} is defined, data will be loaded from this local
dirctory. Otherwise, data will be loaded from the monitoring data repository
maintained by PWFSL.

The annual files loaded by this function are updated on the 15'th of each
month and cover the period from the beginning of the year to the end of the
last month.

For data during the last 45 days, use \code{monitor_loadDaily()}.

For the most recent data, use \code{monitor_loadLatest()}.

Currently supported parameters include the following:
\enumerate{
\item{PM2.5}
}

Avaialble RData files can be seen at:
\href{https://haze.airfire.org/monitoring/}{https://haze.airfire.org/monitoring/}
}
\examples{
\dontrun{
# Fail gracefully if any resources are not available
try({

monitor_loadAnnual(2014) \%>\%
  monitor_subset(stateCodes='MT', tlim=c(20140801,20140901)) \%>\%
  monitor_map()

}, silent = FALSE)
}
}
\seealso{
\code{\link{monitor_loadDaily}}

\code{\link{monitor_loadLatest}}
}
\keyword{AIRSIS}
\keyword{AirNow}
\keyword{WRCC}
