% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PanelBalance.R
\name{print.PanelBalance}
\alias{print.PanelBalance}
\title{Print basic information about PanelBalance objects}
\usage{
\method{print}{PanelBalance}(x, ...)
}
\arguments{
\item{x}{\code{PanelBalance} object}

\item{...}{Not used}
}
\value{
Nothing
}
\description{
Print basic information about PanelBalance objects
}
\examples{
dem$rdata <- runif(runif(nrow(dem)))
dem.panel <- PanelData(dem, "wbcode2", "year", "dem", "y")
pm.obj <- PanelMatch(lead = 0:3, lag = 4, refinement.method = "mahalanobis", 
                     panel.data = dem.panel, match.missing = TRUE,
                     covs.formula = ~ tradewb + rdata + I(lag(tradewb, 1:4)) + I(lag(y, 1:4)), 
                     size.match = 5, qoi = "att")
pb <- get_covariate_balance(pm.obj,
                            include.unrefined = TRUE,
                            panel.data = dem.panel, 
                            covariates = c("tradewb", "rdata"))
print(pb)
}
