% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PanelMatchObject.R
\name{summary.PanelMatch}
\alias{summary.PanelMatch}
\title{Summarize information about a PanelMatch object and the matched sets contained within them.}
\usage{
\method{summary}{PanelMatch}(object, ..., verbose = FALSE)
}
\arguments{
\item{object}{a \code{PanelMatch} object}

\item{...}{Optional additional arguments to be passed to the \code{summary} function}

\item{verbose}{Logical value specifying whether or not a longer, more verbose summary should be calculated and returned. Default is \code{FALSE}.}
}
\value{
A list of lists containing a summary of the matched sets associated with the specified qoi. Each sublist object will either have 5 or 1 element(s), depending on whether or not \code{verbose} is set to \code{TRUE} or not.
\item{overview}{A \code{data.frame} object containing information about the treated units (unit id, time of treatment), and the number of matched control units with weights zero and above.}
\item{set.size.summary}{a \code{summary} object summarizing the minimum, maximum, and IQR of matched set sizes}
\item{number.of.treated.units}{The number of unit, time pairs that are considered to be "treated" units}
\item{num.units.empty.set}{The number of units treated at a particular time that were not able to be matched to any control units}
\item{lag}{The size of the lag window used for matching on treatment history. This affects which treated and control units are matched.}
}
\description{
A method for viewing summary data about the sizes of matched sets and metadata about how they were created. This method
accepts all standard \code{summary} arguments. If the quantity of interest is ate, then a summary will be provided for the matched sets associated with the att and the atc.
}
\examples{
dem.sub <- dem[dem[, "wbcode2"] <= 100, ]
dem.sub.panel <- PanelData(dem.sub, "wbcode2", "year", "dem", "y")
PM.results <- PanelMatch(panel.data = dem.sub.panel,
                         lag = 4, 
                         refinement.method = "mahalanobis",
                         match.missing = TRUE,
                         covs.formula = ~ I(lag(tradewb, 1:4)) + I(lag(y, 1:4)),
                         size.match = 5, qoi = "att",
                         lead = 0:4, forbid.treatment.reversal = FALSE)
summary(PM.results)

}
