% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{pGenPareto}
\alias{pGenPareto}
\title{Distribution Function of the generalized Pareto Distribution}
\usage{
pGenPareto(x, t, alpha_ini, alpha_tail, truncation = NULL)
}
\arguments{
\item{x}{Numeric. The function evaluates the CDF at \code{x}.}

\item{t}{Numeric. Threshold of the generalized Pareto distribution.}

\item{alpha_ini}{Numeric. Initial Pareto alpha.}

\item{alpha_tail}{Numeric. Tail Pareto alpha.}

\item{truncation}{Numeric. If \code{truncation} is not \code{NULL} and \code{truncation > t}, then the generalized Pareto distribution is truncated at \code{truncation}.}
}
\value{
Distribution function of the generalized Pareto distribution with parameters \code{t}, \code{alpha_ini} and \code{alpha_tail} evaluated at \code{x}
}
\description{
Calculates the cumulative distribution function of a generalized Pareto distribution
}
\examples{
x <- 0:10 * 1000
pGenPareto(x, 1000, 1, 3)
pGenPareto(x, 1000, 1, 3, truncation = 5000)


}
