% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eQTM-class.R
\name{create_eQTM}
\alias{create_eQTM}
\title{Create an expression quantitative trait methylation (eQTM) object}
\usage{
create_eQTM(data, metadata = list())
}
\arguments{
\item{data}{A data.frame containing eQTM data with columns: cpg, statistics, p_value, distance, and at least one of entrez or ensembl.
\describe{
  \item{cpg}{Character. CpG probe ID (e.g., "cg00000029"), representing a methylation site.}
  \item{statistics}{Numeric. Test statistic from eQTM association analysis (e.g., correlation coefficient, r-square, regression coefficient, or t-statistic). Can be positive or negative.}
  \item{p_value}{Numeric. P-value associated with the test statistic, must be between 0 and 1.}
  \item{distance}{Numeric. Genomic distance (in base pairs) between the CpG and the associated gene's transcription start site (TSS). Must be non-negative.}
  \item{entrez}{Character. Entrez gene ID of the associated gene. At least one of entrez or ensembl must be provided.}
  \item{ensembl}{Character. Ensembl gene ID of the associated gene. At least one of entrez or ensembl must be provided.}
}}

\item{metadata}{A list of metadata (optional).}
}
\value{
An eQTM object.
}
\description{
Create an expression quantitative trait methylation (eQTM) object
}
\examples{
data <- data.frame(
  cpg = c("cg000001", "cg000002"),
  statistics = c(2.5, -1.8),
  p_value = c(0.01, 0.03),
  distance = c(50000, 80000),
  entrez = c("673", "1956")
)
eqtm_obj <- create_eQTM(data)

}
