% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addDeath.R
\name{addDeathDate}
\alias{addDeathDate}
\title{Add date of death for individuals. Only death within the same observation
period than `indexDate` will be observed.}
\usage{
addDeathDate(
  x,
  indexDate = "cohort_start_date",
  censorDate = NULL,
  window = c(0, Inf),
  deathDateName = "date_of_death"
)
}
\arguments{
\item{x}{Table with individuals in the cdm.}

\item{indexDate}{Variable in x that contains the window origin.}

\item{censorDate}{Name of a column to stop followup.}

\item{window}{window to consider events over.}

\item{deathDateName}{name of the new column to be added.}
}
\value{
table x with the added column with death information added.
}
\description{
Add date of death for individuals. Only death within the same observation
period than `indexDate` will be observed.
}
\examples{
\donttest{
cdm <- mockPatientProfiles()
cdm$cohort1 \%>\%
  addDeathDate()
mockDisconnect(cdm = cdm)
}

}
