% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peptide_cluster_quantification.R
\name{calculate_all_PSM}
\alias{calculate_all_PSM}
\title{Calculate Spectra Count (PSM) for the whole input sequence dataframe}
\usage{
calculate_all_PSM(
  whole_seq,
  matching_result,
  matching_columns,
  distinct_columns,
  with_PTM = FALSE,
  reps = FALSE
)
}
\arguments{
\item{whole_seq}{A dataframe holding whole sequence information. 'Region_Sequence' column is required for the sequence information. Change the column name if it is different than 'Region_Sequence'.}

\item{matching_result}{The dataframe that contains the matched results and PTM information.}

\item{matching_columns}{Vector of column names that should match between each row of 'whole_seq' and the 'matching_result' dataframe.}

\item{distinct_columns}{Vector of column names that should be used to calculate PSM separately for each unique combination of these columns.}

\item{with_PTM}{A boolean parameter indicating whether PTM should be considered during calculation of PSM. Default is \code{FALSE}.}

\item{reps}{A boolean parameter indicating whether the area/intensity should be divided by the number of replicates. Default is \code{FALSE}.}
}
\value{
Returns \code{data_with_psm}, a dataframe contains calculated PSM for each record in 'whole_seq'.
}
\description{
Calculate Spectra Count (PSM) for the whole input sequence dataframe
}
\examples{
whole_seq <- data.frame(
  Region_Sequence = c(
    "XYZAAA",
    "XYZCCC",
    "XYZBBB",
    "XYZDDD",
    "XYZAAB",
    "XYZCCD",
    "XYZBBB",
    "XYZDDD",
    "XYZAAA",
    "XYZCCC",
    "XYZBBB",
    "XYZDDD",
    "XYZAAB",
    "XYZCCD",
    "XYZBBB",
    "XYZDDD"
  ),
  Condition_1 = c(
    "Drug1",
    "Drug1",
    "Drug2",
    "Drug2",
    "Drug1",
    "Drug1",
    "Drug2",
    "Drug2",
    "Drug1",
    "Drug1",
    "Drug2",
    "Drug2",
    "Drug1",
    "Drug1",
    "Drug2",
    "Drug2"
  ),
  Condition_2 = c(
    "Donor1",
    "Donor1",
    "Donor1",
    "Donor1",
    "Donor1",
    "Donor1",
    "Donor1",
    "Donor1",
    "Donor2",
    "Donor2",
    "Donor2",
    "Donor2",
    "Donor2",
    "Donor2",
    "Donor2",
    "Donor2"
  ),
  Region_1 = c(
    "VH",
    "VL",
    "VH",
    "VL",
    "VH",
    "VL",
    "VH",
    "VL",
    "VH",
    "VL",
    "VH",
    "VL",
    "VH",
    "VL",
    "VH",
    "VL"
  ),
  Region_2 = c(
    "Arm_1",
    "Arm_1",
    "Arm_1",
    "Arm_1",
    "Arm_2",
    "Arm_2",
    "Arm_2",
    "Arm_2",
    "Arm_1",
    "Arm_1",
    "Arm_1",
    "Arm_1",
    "Arm_2",
    "Arm_2",
    "Arm_2",
    "Arm_2"
  )
)
matching_result <- data.frame(
  Sequence = c("AAA", "DDD", "DDD"),
  Condition_1 = c("Drug1", "Drug2", "Drug2"),
  Condition_2 = c("Donor1", "Donor2", "Donor2"),
  Region_1 = c("VH", "VL", "VL"),
  Region_2 = c("Arm_1", "Arm_2", "Arm_2"),
  Start_Position = c(4, 4, 4),
  End_Position = c(6, 6, 6),
  PTM_position = c(NA, 2, 0),
  PTM_type = c(NA, "O", "C"),
  Area = c(100, 200, 200),
  reps = c(1, 2, 2)
)
matching_columns <- c("Condition_1", "Region_2")
data_with_psm <- calculate_all_PSM(
  whole_seq,
  matching_result,
  matching_columns,
  distinct_columns = c("Condition_2", "Region_1"),
  with_PTM = TRUE,
  reps = TRUE
)
}
