% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PerMallows.R
\name{expectation.gmm}
\alias{expectation.gmm}
\title{Compute the expected distance, GMM under the Hamming distance}
\usage{
expectation.gmm(theta, dist.name = "kendall")
}
\arguments{
\item{theta}{n dimensional real vector with the dispersion parameters}

\item{dist.name}{optional name of the distance used in the GMM. One of: kendall (default), cayley, hamming}
}
\value{
The expected distance decomposition vector under the GMM
}
\description{
Compute the expected distance in the GMM under the Hamming distance
}
\examples{
expectation.gmm(c(0.38, 0.44, 0.1, 0.2, 1, 0.1))
expectation.gmm(c(2, 2, 2, 2),"cayley")
expectation.gmm(c(0.3, 0.1, 0.5, 0.1),"hamming")
}
\references{
"Ekhine Irurozki, Borja Calvo, Jose A. Lozano (2016). PerMallows: An R Package for Mallows and Generalized Mallows Models. Journal of Statistical Software, 71(12), 1-30. doi:10.18637/jss.v071.i12"
}

