% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_docs.R
\name{pet.find}
\alias{pet.find}
\title{Returns a data.frame of pet records matching input parameters.}
\usage{
pet.find(location, animal = NULL, breed = NULL, size = NULL, sex = NULL,
  age = NULL, offset = NULL, count = NULL, output = NULL,
  pages = NULL, return_df = FALSE)
}
\arguments{
\item{location}{ZIP/postal code, state, or city and state to perform the
search.}

\item{animal}{Return breeds of animal. Must be one of 'barnyard', 'bird', 
'cat', 'dog', 'horse', 'reptile', or 'smallfurry'.}

\item{breed}{Specifies the breed of the animal to search.}

\item{size}{Specifies the size of the animal/breed to search. Must be one of
'S' (small), 'M' (medium), 'L' (large), 'XL' (extra-large).}

\item{sex}{Filters the search to the desired gender of the animal. Must be
one of 'M' (male) or 'F' (female).}

\item{age}{Returns animals with specified age. Must be one of 'Baby',
'Young', 'Adult', 'Senior'.}

\item{offset}{Can be set to the value of lastOffset returned from the
previous call to retrieve the next set of results. The pages parameter can
also be used to pull a desired number of paged results.}

\item{count}{The number of records to return. Default is 25.}

\item{output}{Sets the amount of information returned in each record. 'basic'
returns a simple record while 'full' returns a complete record with
description. Defaults to 'basic'.}

\item{pages}{The number of pages of results to return. For example, if
pages=4 with the default count parameter (25), 125 results would be
returned (25 results from first call and 100 from the next four pages).}

\item{return_df}{If TRUE, the function will coerce the output JSON from the
Petfinder API into a data.frame}
}
\value{
data.frame of pet records matching input parameters.
}
\description{
Returns a data.frame of pet records matching input parameters.
}
\examples{
\dontrun{
pf <- Petfinder(key) # Initialize Petfinder class
pf$pet.find('WA')
pf$pet.find('WA', 'cat', pages = 2)
}
}
