% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{UTEFFTOX}
\alias{UTEFFTOX}
\title{Samples from the posterior of the utility based phase12 model.}
\usage{
UTEFFTOX(YE, YT, Doses, HypermeansEFF, HypermeansTOX, Hypervars, B)
}
\arguments{
\item{YE}{Binary indicator vector of efficacy status.}

\item{YT}{Binary indicator vector of toxicity status.}

\item{Doses}{Vector of integer Doses given to patients.}

\item{HypermeansEFF}{Vector of length nDose for dose prior means for efficacy.}

\item{HypermeansTOX}{Vector of length nDose for dose prior means for toxicity}

\item{Hypervars}{Length 3 vector of hypervariances.Hypervars(1) contains sigma_0^2, Hypervars(2) contains sigma_mu, Hypervars(3) contains tau - the frailty variance.}

\item{B}{Number of iterations to run for the MCMC.}
}
\value{
A list of posterior samples after burnin in order: Posterior efficacy dose-vector, Posterior toxicity dose-vector, Posterior correlation.
}
\description{
Takes arguments of data, hypermens and hypervariance vectors and returns a list of posterior samples from the Utility based phase12 model decribed by Chapple and Thall (2019).
}
\examples{
n=100  #Generate Data
YE=rbinom(n,1,.6)
YT=rbinom(n,1,.2)
nDose=5
Doses=sample(1:nDose,n,replace=TRUE)
##Hyperparameters
HypermeansEFF=c(-1,-.5,0,.5,1,2)
HypermeansTOX=HypermeansEFF
Hypervars=c(1,16,1)
B=100
UTEFFTOX(YE, YT,Doses,HypermeansEFF,HypermeansTOX, Hypervars, B)
}
