% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/safe_selection.R
\name{safe_selection}
\alias{safe_selection}
\title{safe_selection}
\usage{
safe_selection(
  df,
  var_surrogate,
  surrogate_quali,
  threshold = 0.05,
  alpha = 0.5,
  remove_var_surrogate = TRUE,
  bool_weight = FALSE,
  ...
)
}
\arguments{
\item{df}{dataframe}

\item{var_surrogate}{variables used for building the surrogates}

\item{surrogate_quali}{surrogate with 3 values (0 and 1 the extremes and 3 middle patients)}

\item{threshold}{rareness threshold (default = 0.05).}

\item{alpha}{glmnet parameter (default is 0.5 elastic net)}

\item{remove_var_surrogate}{does the glmnet algorithm should learn on features in var_surrogate (default is TRUE).}

\item{bool_weight}{Should the glmnet function be weighted to balance the extrema populations (default is FALSE).}

\item{...}{arguments to pass to pretty_cv.glmnet}
}
\value{
A list
\itemize{
 \item glmnet_model - A list of three elements: the cv.glmnet fitted model, the coefficients of non zero variables and the vector of non zero coefficient variables.
 \item important_var - A vector with the variables used for the surrogate and the non zero variables.
 \item surrogate_quali - The surrogate_quali argument.
}
}
\description{
Select the variables from dataframe by removing the rare variables and apply 'SAFE' on it.
}
