% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spatial_evolution_of_clonotype_plot.R
\name{Spatial_evolution_of_clonotype_plot}
\alias{Spatial_evolution_of_clonotype_plot}
\title{Plotting the phylogenetic network of a clonotype based on the somatic hypermutations of the immune repertoire sequences on a spatial image.}
\usage{
Spatial_evolution_of_clonotype_plot(
  simulation = c(TRUE, FALSE),
  AbForest_output,
  VDJ,
  nb_clonotype,
  simulated_VDJ,
  tracking_type = c("closest", "all"),
  sample_names,
  bcs_merge,
  images_tibble,
  title,
  size,
  legend_title
)
}
\arguments{
\item{simulation}{Logical operator, to describe which type of data we want to plot, TRUE if the data are output of Echidna simulation and FALSE if the we use real dataset.}

\item{AbForest_output}{Igraph of phylogenetic tree of a clonotype of interest found in the large list output from AntibodyForest function, only needed if we use real dataset.}

\item{VDJ}{Data frame containing VDJ information, found in the vgm made by platypus. It must have x and y coordinates column and the column containing the factor to plot.}

\item{nb_clonotype}{Numeric, value which designates the clonotype we want to study if we use simulated data (Echidna output).}

\item{simulated_VDJ}{Large list, output of Echidna simulate_repertoire function. Only needed if we use simulated data.}

\item{tracking_type}{Integer, to define how daughter cells are linked to mother cells.If "all" parameter it means that each daughter cell is link by all these potential mother cells and if "closest" parameter, only closest potential mother cell is link to the daughter cell.}

\item{sample_names}{Character vector containing the name of the sample.}

\item{bcs_merge}{Data frame containing imagerow, imagecol and barcode of the cells belonging to the spatial image. It can also be created by the function scaling_spatial_image_parameter by selecting the output parameter 10.}

\item{images_tibble}{Tbl-df containing the sample name, grob, height and width of the spatial image. It can also be created by the function scaling_spatial_image_parameter by selecting the output parameter 5.}

\item{title}{Character vector to name the plot.}

\item{size}{Number, to define the size of the text, default = 15.}

\item{legend_title}{Character vector to name the legend scale.}
}
\value{
Plot of phylogenetic network of a clonotype of interest.
}
\description{
Plotting the phylogenetic network of a clonotype based on the somatic hypermutations of the immune repertoire sequences on a spatial image.
}
\examples{
\dontrun{
Spatial_evolution_of_clonotype_plot(simulation = FALSE,
tracking_type = "closest",AbForest_output = forest$s1$clonotype10,VDJ=vgm$VDJ,
sample_names = sample_names, images_tibble = scaling_parameters[[5]],
bcs_merge = scaling_parameters[[10]],
title = "Tracking evolution of clonotype 10", legend_title = "nb of SHM" )

Spatial_evolution_of_clonotype_plot(simulation = FALSE,tracking_type = "all",
AbForest_output = forest$s1$clonotype10,VDJ=vgm$VDJ,
sample_names = sample_names, images_tibble = scaling_parameters[[5]],
bcs_merge = scaling_parameters[[10]],
title = "Tracking evolution of clonotype 10", legend_title = "nb of SHM" )

Spatial_evolution_of_clonotype_plot(simulation = TRUE,tracking_type = "closest",
nb_clonotype = 11 ,simulated_VDJ = simulated_B_cells_VDJ,
VDJ =vgm_with_simulated_VDJ$VDJ,bcs_merge = bcs_merge,
images_tibble = scaling_parameters[[5]],title = "B cell density",
legend_title = "nb_of_SHM",sample_names=sample_names)

Spatial_evolution_of_clonotype_plot(simulation = TRUE,tracking_type = "all",
nb_clonotype = 11 ,simulated_VDJ = simulated_B_cells_VDJ,
VDJ =vgm_with_simulated_VDJ$VDJ,bcs_merge = bcs_merge,
images_tibble = scaling_parameters[[5]],title = "B cell density",
legend_title = "nb_of_SHM",sample_names=sample_names)
}
}
