% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spatial_vgm_formation.R
\name{Spatial_vgm_formation}
\alias{Spatial_vgm_formation}
\title{Addition of the spatial information to the VGM matrix, output of VDJ_GEX_matrix()}
\usage{
Spatial_vgm_formation(
  vgm,
  tissue_lowres_image_path,
  scalefactors_json_path,
  tissue_positions_list_path,
  cluster_path,
  matrix_path
)
}
\arguments{
\item{vgm}{Large list, output of VDJ_GEX_matrix()}

\item{tissue_lowres_image_path}{Path to file containing the image of the tissue in png format}

\item{scalefactors_json_path}{Path to a file for converting pixel positions in the original, full-resolution image to pixel positions in the histological image in json format}

\item{tissue_positions_list_path}{Path to a text file containing a table with rows that correspond to spots in csv format}

\item{cluster_path}{Path to 10X Genomic clustering file that is not specific for immune cells, in csv format}

\item{matrix_path}{Path to the filtered feature barcode matrix containing barcode from fixed list of known-good barcode sequences in the h5 format}
}
\value{
Returns the input VGM matrix (output of VDJ_GEX_matrix()) with an additional list containing the spatial information.
}
\description{
Addition of the spatial information to the VGM matrix, output of VDJ_GEX_matrix()
}
\examples{
\dontrun{
#Needed spatial files
tissue_lowres_image_path<-list()
tissue_lowres_image_path[[1]]<-c("c:/.../tissue_lowres_image.png")

scalefactors_json_path<-list()
scalefactors_json_path[[1]]<-c("c:/.../scalefactors_json.json")

tissue_positions_list_path<-list()
tissue_positions_list_path[[1]]<-c("c:/.../tissue_positions_list.csv")

cluster_path<-list()
cluster_path[[1]]<-c("c:/.../analysis/clustering/graphclust/clusters.csv")

matrix_path<-list()
matrix_path[[1]]<-c("c:/.../filtered_feature_bc_matrix/filtered_feature_bc_matrix.h5")

#VGM formation with spatial data
vgm_spatial<-Spatial_vgm_formation(vgm = vgm_without_spatial_data_and_VDJ,
tissue_lowres_image_path = tissue_lowres_image_path,
tissue_positions_list_path = tissue_positions_list_path,
scalefactors_json_path = scalefactors_json_path,
cluster_path = cluster_path, matrix_path = matrix_path)
}
}
