% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{conversion}
\alias{conversion}
\alias{absorbance_to_transmittance}
\alias{transmittance_to_absorbance}
\title{Convert Between Absorbance and Transmittance}
\usage{
absorbance_to_transmittance(ftir)

transmittance_to_absorbance(ftir)
}
\arguments{
\item{ftir}{A data.frame of FTIR spectral data including column to be
  converted. Can't contain both `absorbance` and `transmittance` column as
  the receiving column would be overwritten

  Un data.frame de données spectrales IRTF incluant la colonne à convertir.
  Ne peut pas contenir les colonnes `absorbance` et `transmittance` car la
  colonne de réception serait écrasée.}
}
\value{
a data.frame of FTIR spectral data with conversion between absorbance
  or transmittance as requested. Note the original data column is removed
  since FTIR spectral data frames can't be fed into plotting functions with
  both transmittance and absorbance data included.

  un data.frame de données spectrales IRTF avec conversion entre l'absorbance
  ou la transmittance comme demandé. Notez que la colonne de données
  d'origine est supprimée car les trames de données spectrales IRTF ne
  peuvent pas être introduites dans les fonctions de tracé avec les données
  de transmittance et d'absorbance incluses.
}
\description{
These functions allow for the convenient conversion between
  \%Transmittance and Absorbance units for the Y axis.

  Converting between \%Transmittance and absorbance units for the Y axis is
  not a simple flipping of axis or inversion. Instead, the two are related by
  the following formulas:

\deqn{
 A=-log_{10}(\tfrac{\%T}{100})
}
  and
\deqn{
 \%T=10^{-A}\cdot 100
}.

  Ces fonctions permettent une conversion pratique entre les unités
  \%Transmittance et Absorbance pour l'axe Y. La conversion entre les unités
  \%Transmittance et Absorbance pour l'axe Y n'est pas un simple retournement
  d'axe ou une inversion. Au lieu de cela, les deux sont liés par les
  formules suivantes :

\deqn{
 A=-log_{10}(\tfrac{\%T}{100})
}
  and
\deqn{
 \%T=10^{-A}\cdot 100
}
}
\examples{
# Convert from absorbance to transmittance
sample_spectra_transmittance <- absorbance_to_transmittance(sample_spectra)

# Convert back to absorbance
sample_spectra_absorbance <- transmittance_to_absorbance(sample_spectra_transmittance)

}
