% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PoloniexTrading.R
\name{SetPoloniexTradingCommands}
\alias{SetPoloniexTradingCommands}
\title{Setter for REST service commands for the Poloniex Trading API.}
\usage{
SetPoloniexTradingCommands(theObject, commands)
}
\arguments{
\item{theObject}{The Trading client API object on which the function should be called}

\item{commands}{-  a list with Key/value string pairs
Represents the command strings for the respective Trading API functions.}
}
\value{
theObject - a copy of the object with the modified command slot.
}
\description{
Setter for REST service commands for the Poloniex Trading API.
}
\examples{
\dontrun{
poloniex.trading <- PoloniexTradingAPI(your.key, your.secret)
GetPoloniexTradingCommands(poloniex.trading)
commands.new <- list(returnTradeHistory = "returnTradeHistory.new",
                     withdraw = "withdraw.new")
poloniex.trading <- SetPoloniexTradingCommands(poloniex.trading,
                                               commands = commands.new)
GetPoloniexTradingCommands(poloniex.trading)
}
}
