% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PolyHaplotyper.R
\name{getFSfreqs}
\alias{getFSfreqs}
\title{get all FS haplotype combinations expected from two parental haplotype
combinations, with their frequencies}
\usage{
getFSfreqs(parhac, DRrate)
}
\arguments{
\item{parhac}{matrix with one column for each parent and <ploidy> rows,
giving the haplotype combinations for each parent}

\item{DRrate}{the rate of double reduction per meiosis (NOT per allele!); e.g.
with a DRrate of 0.04, a tetraploid parent with genotype ABCD will produce
a fraction of 0.04 of DR gametes AA, BB, CC and DD (each with a frequency of
0.01), and a fraction of 0.96 of the non-DR gametes AB, AC, AD, BC, BD, CD
(each with a frequency of 0.16)}
}
\value{
a list of 2 elements:\cr
FShac: a matrix with one column per unique FS haplotype combination and
the same row count as parhac, giving the FS haplotype combinations. There are
no duplicated columns but several (not necessarily adjacent) columns
may correspond to the same mrkdid\cr
freq: a vector of length ncol(hapcomb), with for each FS haplotype combination
in hapcomb its frequency (0.0 ... 1.0). The colnames are NULL: haplotype
combinations are not named.
}
\description{
get all FS haplotype combinations expected from two parental
haplotype combinations, with their frequencies. Different from getFScombs in
that it returns the unique FS combinations as well as their frequencies, and
that it also considers Double Reduction
}
\examples{
# specify combinations of haplotypes in two tetraploid parents:
hapcomb <- matrix(c(2,2,5,6, 1,2,5,5), ncol=2)
# FS frequencies without double reduction:
getFSfreqs(parhac=hapcomb, DRrate=0)
# FS frequencies with 5\\% double reduction:
getFSfreqs(parhac=hapcomb, DRrate=0.05)
}
