% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_score_lr.R
\name{score_lr_single}
\alias{score_lr_single}
\title{Analyze Ligand-Receptor Projection Scores (Specified Sender and Receiver)}
\usage{
score_lr_single(
  rna,
  sender,
  receiver,
  filtered_lr,
  sample_col,
  cell_type_col,
  min_cells = 50,
  num_cores = 10,
  verbose = TRUE
)
}
\arguments{
\item{rna}{A Seurat object containing single-cell RNA expression data.}

\item{sender}{Cell type designated as the ligand sender (character).}

\item{receiver}{Cell type designated as the receptor receiver (character).}

\item{filtered_lr}{A data frame of filtered ligand-receptor pairs from prior analysis (e.g., output of \code{filter_lr_single}).
Must contain an "lr" column with pair identifiers in "Ligand_Receptor" format.}

\item{sample_col}{Column name in Seurat metadata indicating sample identifiers (character).}

\item{cell_type_col}{Column name in Seurat metadata indicating cell type classifications (character).}

\item{min_cells}{Minimum cells required per sample for both sender and receiver (numeric, default 50).}

\item{num_cores}{Number of CPU cores for parallel processing (numeric, default 10). Automatically capped at (system cores - 1).}

\item{verbose}{Logical indicating whether to print progress messages (logical, default: TRUE).}
}
\value{
A data frame with projection scores per sample and LR pair. Columns:
\item{All input from \code{filtered_lr}}{Original columns provided by the user in \code{filtered_lr}.}
\item{sample}{Sample identifier.}
\item{score}{Projection score (raw co-expression intensity).}
\item{normalized_score}{Normalized score scaled between 0-1.}
Rows are ordered by \code{filtered_lr} columns and descending \code{score}.

Returns \code{NULL} if:
\itemize{
\item No cell types are found in the metadata.
\item One or both of the specified sender and receiver cell types are missing in the data.
\item Fewer than two valid samples remain after filtering based on minimum cell number per sample.
}
}
\description{
This function calculates the projection scores for ligand-receptor (LR) pairs
between specified sender and receiver cell types. The projection score is computed
based on linear regression models, measuring the normalized distance of each sample's
LR expression from the origin of the regression line.
}
\examples{
\donttest{
  # Long-running example (may take >10s)
  seurat_object <- load_example_seurat()
  data(lr_db)

  # Analyzing ligand-receptor interactions: Cardiac -> Perivascular
  result01s <- filter_lr_single(
    rna = seurat_object,
    sender = "Cardiac",
    receiver = "Perivascular",
    lr_database = lr_db,
    sample_col = "sample",
    cell_type_col = "cell.type",
    min_cells = 20,
    min_samples = 10,
    min_adjust_p = 0.5,
    num_cores = 1,
    verbose = TRUE
  )

  # Analyzing ligand-receptor projection scores: Cardiac -> Perivascular
  result02s <- score_lr_single(
    rna = seurat_object,
    sender = "Cardiac",
    receiver = "Perivascular",
    filtered_lr = result01s,
    sample_col = "sample",
    cell_type_col = "cell.type",
    min_cells = 20,
    num_cores = 1,
    verbose = TRUE
  )

  if (!is.null(result02s)) {
  print(head(result02s))
  }
}
}
