% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFrontiers.R
\name{plotFrontiers}
\alias{plotFrontiers}
\title{Generate efficient frontiers plot by providing frontiers.}
\usage{
plotFrontiers(
  R,
  frontiers,
  risk,
  ES_alpha = 0.05,
  EQS_alpha = 0.05,
  moment_setting = NULL,
  main = "Efficient Frontiers",
  plot_type = "l",
  cex.axis = 0.5,
  element.color = "darkgray",
  legend.loc = NULL,
  legend.labels = NULL,
  cex.legend = 0.8,
  xlim = NULL,
  ylim = NULL,
  ...,
  labels.assets = TRUE,
  pch.assets = 21,
  cex.assets = 0.8,
  col = NULL,
  lty = NULL,
  lwd = NULL
)
}
\arguments{
\item{R}{an xts object of asset returns}

\item{frontiers}{a list of frontiers, for example, list(ef1=meanvar.efficient.frontier(), ef2=meanvar.efficient.frontier())}

\item{risk}{type of risk that you want to compare, could be 'StdDev', 'ES', 'EQS'}

\item{ES_alpha}{the default value is 0.05, but could be specified as any value between 0 and 1}

\item{EQS_alpha}{the default value is 0.05, but could be specified as any value between 0 and 1}

\item{moment_setting}{the default is NULL, if customize momentFUN please provide moment_setting=list(mu=, sigma=)}

\item{main}{title used in the plot.}

\item{plot_type}{define the plot_type, default is "l"}

\item{cex.axis}{the magnification to be used for sizing the axis text relative to the current setting of 'cex', similar to \code{\link{plot}}.}

\item{element.color}{provides the color for drawing less-important chart elements, such as the box lines, axis lines, etc.}

\item{legend.loc}{location of the legend; NULL, "bottomright", "bottom", "bottomleft", "left", "topleft", "top", "topright", "right" and "center".}

\item{legend.labels}{character vector to use for the legend labels.}

\item{cex.legend}{The magnification to be used for sizing the legend relative to the current setting of 'cex', similar to \code{\link{plot}}.}

\item{xlim}{set the x-axis limit, same as in \code{\link{plot}}.}

\item{ylim}{set the y-axis limit, same as in \code{\link{plot}}.}

\item{\dots}{passthrough parameters to \code{\link{plot}}.}

\item{labels.assets}{TRUE/FALSE to include the asset names in the plot.}

\item{pch.assets}{plotting character of the assets, same as in \code{\link{plot}}.}

\item{cex.assets}{A numerical value giving the amount by which the asset points and labels should be magnified relative to the default.}

\item{col}{vector of colors with length equal to the number of portfolios in \code{frontiers}.}

\item{lty}{vector of line types with length equal to the number of portfolios in \code{frontiers}.}

\item{lwd}{vector of line widths with length equal to the number of portfolios in \code{frontiers}.}
}
\description{
Generate efficient frontiers plot by providing frontiers.
}
\details{
This function provides the ability to plot frontiers based on the result of 
`meanvar.efficient.frontier`, `meanetl.efficient.frontier` or `meaneqs.efficient.frontier`.

When using \code{meanvar.efficient.frontier}, \code{meanetl.efficient.frontier} 
and \code{meaneqs.efficient.frontier}, the result will be frontiers data,
including the weights for each point on the mean-risk efficient frontiers. 
Before using this function, user should declare which risk that they want to 
compare, and what parameters that they want to use to calculate the risk, 
e.g. \code{ES_alpha} for ES, \code{moment_setting} for var. Then this function 
will calculate back mean and risk based on the weight, and draw a plot.

Default settings use colors and line types to differentiate portfolios, and set 
the portfolio name as 'Portfolio 1' and so on. Users could customize col, lty, 
lwd and legend.labels to better the plot.
}
\author{
Xinran Zhao
}
