/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.examples.producer;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.openfast.Context;
import org.openfast.Message;
import org.openfast.MessageOutputStream;
import org.openfast.error.ErrorHandler;
import org.openfast.examples.MessageBlockWriterFactory;
import org.openfast.examples.producer.FastMessageProducer;
import org.openfast.session.Connection;
import org.openfast.session.Endpoint;
import org.openfast.session.FastConnectionException;

public class MulticastFastMessageProducer
extends FastMessageProducer {
    private MessageOutputStream out;

    public MulticastFastMessageProducer(Endpoint endpoint, File templatesFile) throws IOException, FastConnectionException {
        this(endpoint, templatesFile, new MessageBlockWriterFactory(), false);
    }

    public MulticastFastMessageProducer(Endpoint endpoint, File templatesFile, MessageBlockWriterFactory messageBlockWriterFactory, boolean shouldResetOnEveryMessage) throws IOException, FastConnectionException {
        super(endpoint, templatesFile, messageBlockWriterFactory, shouldResetOnEveryMessage);
        Context context = new Context();
        context.setErrorHandler(ErrorHandler.NULL);
        context.setTemplateRegistry(this.templateRegistry);
        this.out = new MessageOutputStream(endpoint.connect().getOutputStream(), context);
        this.out.setBlockWriter(messageBlockWriterFactory.create());
    }

    protected void publish(List messages, List msgOutputStreams) {
        if (this.out == null) {
            return;
        }
        int i = 0;
        while (i < messages.size()) {
            this.out.writeMessage((Message)messages.get(i), true);
            ++i;
        }
        if (this.shouldResetOnEveryMessage) {
            this.out.reset();
        }
    }

    public void start() {
        System.out.println("Publishing on " + this.endpoint);
    }

    public void onConnect(Connection connection) {
    }
}

