/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.session.template.exchange;

import java.util.HashMap;
import java.util.Map;
import org.openfast.FieldValue;
import org.openfast.GroupValue;
import org.openfast.Message;
import org.openfast.QName;
import org.openfast.ScalarValue;
import org.openfast.session.SessionControlProtocol_1_1;
import org.openfast.session.template.exchange.AbstractFieldInstructionConverter;
import org.openfast.session.template.exchange.ConversionContext;
import org.openfast.template.Field;
import org.openfast.template.Group;
import org.openfast.template.MessageTemplate;
import org.openfast.template.Scalar;
import org.openfast.template.TemplateRegistry;
import org.openfast.template.operator.Operator;
import org.openfast.template.type.Type;

public class ScalarConverter
extends AbstractFieldInstructionConverter {
    private final Map TYPE_TEMPLATE_MAP = new HashMap();
    private final Map TEMPLATE_TYPE_MAP = new HashMap();

    public ScalarConverter() {
        this.TYPE_TEMPLATE_MAP.put(Type.I32, SessionControlProtocol_1_1.INT32_INSTR);
        this.TYPE_TEMPLATE_MAP.put(Type.U32, SessionControlProtocol_1_1.UINT32_INSTR);
        this.TYPE_TEMPLATE_MAP.put(Type.I64, SessionControlProtocol_1_1.INT64_INSTR);
        this.TYPE_TEMPLATE_MAP.put(Type.U64, SessionControlProtocol_1_1.UINT64_INSTR);
        this.TYPE_TEMPLATE_MAP.put(Type.DECIMAL, SessionControlProtocol_1_1.DECIMAL_INSTR);
        this.TYPE_TEMPLATE_MAP.put(Type.UNICODE, SessionControlProtocol_1_1.UNICODE_INSTR);
        this.TYPE_TEMPLATE_MAP.put(Type.ASCII, SessionControlProtocol_1_1.ASCII_INSTR);
        this.TYPE_TEMPLATE_MAP.put(Type.STRING, SessionControlProtocol_1_1.ASCII_INSTR);
        this.TYPE_TEMPLATE_MAP.put(Type.BYTE_VECTOR, SessionControlProtocol_1_1.BYTE_VECTOR_INSTR);
        this.TEMPLATE_TYPE_MAP.put(SessionControlProtocol_1_1.INT32_INSTR, Type.I32);
        this.TEMPLATE_TYPE_MAP.put(SessionControlProtocol_1_1.UINT32_INSTR, Type.U32);
        this.TEMPLATE_TYPE_MAP.put(SessionControlProtocol_1_1.INT64_INSTR, Type.I64);
        this.TEMPLATE_TYPE_MAP.put(SessionControlProtocol_1_1.UINT64_INSTR, Type.U64);
        this.TEMPLATE_TYPE_MAP.put(SessionControlProtocol_1_1.DECIMAL_INSTR, Type.DECIMAL);
        this.TEMPLATE_TYPE_MAP.put(SessionControlProtocol_1_1.UNICODE_INSTR, Type.UNICODE);
        this.TEMPLATE_TYPE_MAP.put(SessionControlProtocol_1_1.ASCII_INSTR, Type.ASCII);
        this.TEMPLATE_TYPE_MAP.put(SessionControlProtocol_1_1.BYTE_VECTOR_INSTR, Type.BYTE_VECTOR);
    }

    public Field convert(GroupValue fieldDef, TemplateRegistry templateRegistry, ConversionContext context) {
        Type type = (Type)this.TEMPLATE_TYPE_MAP.get(fieldDef.getGroup());
        boolean optional = fieldDef.getBool("Optional");
        ScalarValue initialValue = ScalarValue.UNDEFINED;
        if (fieldDef.isDefined("InitialValue")) {
            initialValue = (ScalarValue)fieldDef.getValue("InitialValue");
        }
        Scalar scalar = null;
        String name = fieldDef.getString("Name");
        String namespace = "";
        if (fieldDef.isDefined("Ns")) {
            namespace = fieldDef.getString("Ns");
        }
        QName qname = new QName(name, namespace);
        if (fieldDef.isDefined("Operator")) {
            GroupValue operatorGroup = fieldDef.getGroup("Operator").getGroup(0);
            Operator operator = ScalarConverter.getOperator(operatorGroup.getGroup());
            scalar = new Scalar(qname, type, operator, initialValue, optional);
            if (operatorGroup.isDefined("Dictionary")) {
                scalar.setDictionary(operatorGroup.getString("Dictionary"));
            }
            if (operatorGroup.isDefined("Key")) {
                String keyName = operatorGroup.getGroup("Key").getString("Name");
                String ns = operatorGroup.getGroup("Key").getString("Ns");
                scalar.setKey(new QName(keyName, ns));
            }
        } else {
            scalar = new Scalar(qname, type, Operator.NONE, initialValue, optional);
        }
        if (fieldDef.isDefined("AuxId")) {
            scalar.setId(fieldDef.getString("AuxId"));
        }
        return scalar;
    }

    public GroupValue convert(Field field, ConversionContext context) {
        Scalar scalar = (Scalar)field;
        MessageTemplate scalarTemplate = (MessageTemplate)this.TYPE_TEMPLATE_MAP.get(scalar.getType());
        Message scalarMsg = new Message(scalarTemplate);
        ScalarConverter.setNameAndId(scalar, scalarMsg);
        scalarMsg.setInteger("Optional", scalar.isOptional() ? 1 : 0);
        if (!scalar.getOperator().equals((Object)Operator.NONE)) {
            scalarMsg.setFieldValue("Operator", (FieldValue)new GroupValue(scalarTemplate.getGroup("Operator"), new FieldValue[]{ScalarConverter.createOperator(scalar)}));
        }
        if (!scalar.getDefaultValue().isUndefined()) {
            scalarMsg.setFieldValue("InitialValue", (FieldValue)scalar.getDefaultValue());
        }
        return scalarMsg;
    }

    public Group[] getTemplateExchangeTemplates() {
        return this.TEMPLATE_TYPE_MAP.keySet().toArray(new Group[this.TEMPLATE_TYPE_MAP.size()]);
    }

    public boolean shouldConvert(Field field) {
        return field.getClass().equals(Scalar.class);
    }
}

