% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{filter_rank}
\alias{filter_rank}
\title{Select Top or Bottom N Stocks by Signal}
\usage{
filter_rank(signal_df, n, type = c("top", "worst"))
}
\arguments{
\item{signal_df}{Data frame with Date column and signal values}

\item{n}{Number of stocks to select}

\item{type}{"top" for highest values, "worst" for lowest values}
}
\value{
Binary selection matrix (1 = selected, 0 = not selected)
}
\description{
Selects the top N (best) or worst N stocks based on signal strength.
Optimized using matrix operations for 5-10x speedup.
}
\examples{
data("sample_prices_weekly")
momentum <- calc_momentum(sample_prices_weekly, 12)
# Select 10 highest momentum stocks
top10 <- filter_rank(momentum, 10, type = "top")
}
