% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gerarpn.R
\name{dpn}
\alias{dpn}
\alias{ppn}
\alias{qpn}
\alias{rpn}
\title{The PN distribution}
\description{Density, distribution function, quantile function and random generation for the PN distribution with power equal to alpha.
}
\usage{
dpn(x, alpha)
ppn(q, alpha)
qpn(p, alpha)
rpn(n, alpha)
}
\arguments{
\item{x, q}{vector of observations or quantiles.}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}

\item{alpha}{power parameter.}
}

\details{ The alpha parameter must be greater than 0 \code{(alpha > 0)}. }

%\value{
%Returns a vector of n observations of the PN distribution.
%}

\references{
  Lehmann, EL. (1953). The power of rank tests.
  \emph{The Annals of Mathematical Statistics}, \bold{24}, 23--43.

  Durrans, SR. (1992). Distributions of fractional order statistics in hydrology.
  \emph{Water Resources Research}, \bold{28}, 1649--1655.

  Agamez-Montavo, G. (2017). Modelos de mistura finita usando a classe de distribuicoes alpha potencia.
  \emph{Thesis (Doctoral)}, University of Sao Paulo.

}


\examples{
# Density

dpn(2,1)
dnorm(2)

# Distribution function

ppn(2,1)
pnorm(2)

# Quantile function

qpn(0.5,1)
qnorm(0.5)


# Random generation

alpha <- 0.5
n <- 10
rpn(n, alpha)
}

