\name{sampleN.scABEL}
\alias{sampleN.scABEL}
\title{
Sample size estimation for BE decision via scaled (widened) BE acceptance limits
}
\description{
This function performs the Sample size estimation for the BE decision via 
scaled (widened) BE acceptance limits based on simulations.
}
\usage{
sampleN.scABEL(alpha = 0.05, targetpower = 0.8, theta0, theta1, theta2, 
               CV, design = c("2x3x3", "2x2x4"), regulator = c("EMA", "FDA"), 
               nsims = 1e+05, nstart, print = TRUE, details = TRUE, setseed = TRUE)
}
\arguments{
  \item{alpha}{
Type I error probability. Per convention mostly set to 0.05.
}
  \item{targetpower}{
Power to achieve at least. Must be >0 and <1.\cr
Typical values are 0.8 or 0.9.
}
  \item{theta0}{
'True' or assumed bioequivalence ratio. \cr
Defaults to 0.95 if given explicitly.
}
  \item{theta1}{
Conventional lower ABE limit to be applied in the mixed procedure if 
CVsWR <= CVswitch.\cr
Also Lower limit for the point estimator constraint.\cr
Defaults to 0.8 if not given explicitly.
}
  \item{theta2}{
Conventional upper ABE limit to be applied in the mixed procedure if 
CVsWR <= CVswitch. Also upper limit for the point estimator constraint.\cr
Defaults to 1.25 if not given explicitly.
}
  \item{CV}{
Coefficient(s) of variation as ratio.\cr
If \code{length(CV) = 1} the same CV is assumed for Test and Reference.\cr
If \code{length(CV) = 2} the CV for Test must be given in CV[1] and for 
Reference in CV[2].
}
  \item{design}{
Design of the study to be planned.\cr
2x3x3 is the partial replicate design (TRR/RTR/RRT).\cr
2x2x4 is the full replicate design with 2 sequences and 4 periods.\cr
Defaults to \code{design="2x3x3"}
}
  \item{regulator}{
Regulatory body settings for the widening of the BE acceptance limits.\cr
Defaults to \code{design="EMA"}.
}
  \item{nsims}{
Number of simulations to be performed to obtain the (empirical) power.
The default value 100 000 = 1e+5 is usually sufficient. Consider to rise 
this value if theta0<=0.85 or >=1.25. But see the warning section.
}
  \item{nstart}{
Set this to a start for the sample size search if a previous run failed.\cr
After reworking the start n in version 1.1-05 seldom needed.
}
  \item{print}{
If TRUE (default) the function prints its results.
}
  \item{details}{
If set to \code{TRUE}, the default, the steps during sample size search are shown.
}
  \item{setseed}{
Simulations are dependent on the starting point of the (pseudo) random number 
generator. To avoid differences in power for different runs a \code{set.seed(123456)} 
is issued if \code{setseed=TRUE}, the default. 
}
}
\details{
The simulations are done via the distributional properties of the statistical
quantities necessary for deciding BE based on widened ABEL. For more details see
a document in the doc subdirectory of the package.
}
\value{
Returns now a data.frame with the input and sample size results.\cr
The "Sample size" column contains the total sample size.\cr
The "nlast" column contains the last n value. May be useful for restarting.
}
\references{
Laszlo Tothfalusi and Laszlo Endrenyi\cr
"Sample Sizes for Designing Bioequivalence Studies for Highly Variable Drugs"\cr
J. Pharm. Pharmaceut. Sci. (www.cspsCanada.org) 15(1) 73 - 84, 2011
}
\author{
D. Labes
}
\note{
We are doing the sample size estimation only for balanced designs since the 
break down of the total subject number in case of unbalanced sequence groups
is not unique. Moreover the formulas used are only for balanced designs.\cr
In case of \code{regulator="FDA"} the sample size is only approximate since
the BE decision method is not exactly what is expected by the FDA. But the two
Laszlo's state that the scABEL method should be 'operational' equivalent to the
FDA method. Thus the sample size should be comparable.\cr
Consider in case of \code{regulator="FDA"} to use the function 
\code{sampleN.RSABE()}. 
}

\section{Warning }{
The sample size estimation for very extreme theta0 (<0.83 or >1.21) may be very 
time consuming and will eventually also fail since the start values chosen are 
not really reasonable in that ranges. This is especially true in the range around 
CV = 0.3 and regulatory constant according to FDA.\cr
If you really need sample sizes in that range be prepared to restart the sample 
size estimation via the argument nstart.\cr
Since the dependence of power from n is very flat in the mentioned region you may 
also consider to adapt the number of simulations not to tap in the simulation 
error trap.\cr\cr
See also the Warning section of the function \code{power.scABEL()} concerning
the power value agreement to those obtained from simulations via subject data.
}

\seealso{
\code{\link{power.scABEL}}, \code{\link{power.RSABE}}, \code{\link{sampleN.RSABE}}
}
\examples{
# using all the defaults:
# partial replicate design, targetpower=80\%,
# true assumed ratio = 0.95, 1E+5 simulated studies
# ABE limits, PE constraint 0.8 - 1.25
# EMA regulatory settings
sampleN.scABEL(CV=0.3)
# results in a sample size n=27, power=0.82566

# for the full replicate design, target power = 90\%
# true assumed ratio = 0.9, FDA regulatory settings
sampleN.scABEL(CV=0.4, targetpower=0.9, theta0=0.9, design="2x2x4", regulator="FDA")
# should result in a sample size n=30, power=0.91295

}
