#' PowerfulMaxEigenpair: A package for computating the maximal eigenpair for a matrix.
#'
#' The PowerfulMaxEigenpair package provides some auxillary functions and
#' five categories of important functions:
#' \code{\link{tridiag}}, \code{\link{thomas.tri.sol}}, 
#' \code{\link{powerful.maxeig.tri}} and \code{\link{powerful.seceig.tri}}.
#'
#' @section PowerfulMaxEigenpair functions:
#' \code{\link{tridiag}}: generate tridiagonal matrix Q based on three input vectors.
#'
#' \code{\link{thomas.tri.sol}}: construct the solution of linear equation (-Q-zI)w=v.
#' 
#' \code{\link{powerful.maxeig.tri}}: calculate the maximal eigenpair for the tridiagonal matrix by
#' Thomas algorithm.
#'
#' \code{\link{powerful.seceig.tri}}: calculate next to the maximal eigenpair for the tridiagonal matrix by
#' Thomas algorithm.
#' 
#' 
#' @docType package
#' @name PowerfulMaxEigenpair
NULL
