% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClassPerm.R
\name{ClassPerm}
\alias{ClassPerm}
\title{Permutation Analysis for classification}
\usage{
ClassPerm(Data, classCol, selectedCols, classifierFun, nSims = 1000,
  plot = TRUE, ...)
}
\arguments{
\item{Data}{(dataframe) dataframe of the data}

\item{classCol}{(numeric) column number that contains the variable to be predicted}

\item{selectedCols}{(optional) (numeric) all the columns of data that would be used either as predictor or as feature}

\item{classifierFun}{(optional) (function) classifier function}

\item{nSims}{(optional) (numeric) number of simulations}

\item{plot}{(optional) (logical) whether to plot null accuracy distribution}

\item{...}{(optional) additional arguments for the function}
}
\value{
Returns \code{actualAcc} of the classification analysis,
 \code{p-value} from permutation testing, \code{nullAcc} distribution of the permutation \code{figure} containing null distribution
}
\description{
simple function to create permutation testing of a classifier
}
\details{
The function implements Permutation tests for classification.
Permutation tests are a set of non-parametric methods for hypothesis testing without assuming 
a particular distribution (Good, 2005). In case of classification analysis, this requires 
shuffling the labels of the dataset (i.e. randomly shuffling classes/conditions between observations)
  and calculating accuracies obtained.
}
\examples{
# perform a permutation testing for 10\% of the kinematics movement data
# not run
# PermutationResult <- ClassPerm(Data = KinData, classCol = 1,
#  selectedCols = c(1,2,12,22,32,42,52,62,72,82,92,102,112), nSims = 1000)

}
\author{
Atesh Koul, C'MON unit, Istituto Italiano di Tecnologia

\email{atesh.koul@iit.it}
}

