% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DTModel.R
\name{DTModel}
\alias{DTModel}
\title{Generic Decision Tree Function}
\usage{
DTModel(Data, classCol, selectedCols, tree, ...)
}
\arguments{
\item{Data}{(dataframe) a data frame with regressors and response}

\item{classCol}{(numeric) which column should be used as response col}

\item{selectedCols}{(optional)(numeric) which columns should be treated as data(features + response) (defaults to all columns)}

\item{tree}{which decision tree model to implement; One of the following values:
\itemize{
\item CART     =   Classification And Regression Tree; 
\item CARTNAHF = Crossvalidated Half Model CART Tree removing missing values;
\item CARTHF =   Crossvalidated Half Model CART Tree With missing values;
\item CF =   Conditional inference framework Tree;
\item RF =   Random Forest Tree;    
}}

\item{...}{(optional) additional arguments for the function}
}
\value{
model result for the input tree \code{Results}
}
\description{
A simple function to create Decision Trees
}
\details{
The function implements the Decision Tree models (DT models).
DT models fall under the general "Tree based methods"
involving generation of a recursive binary tree (Hastie et al., 2009).
In terms of input, DT  models can handle both continuous and categorical variables
as well as missing data. From the input data, DT  models build a set of logical "if ..then" rules
that permit accurate prediction of the input cases.

Unlike regression methods like GLMs,  Decision Trees are more flexible and can model nonlinear interactions.
}
\examples{
# generate a cart model for 10\% of the data with cross-validation
model <- DTModel(Data = KinData[,c(1,2,12,22,32,42,52,62,72,82,92,102,112)],
classCol=1,tree='CARTHF')

}
\author{
Atesh Koul, C'MON unit, Istituto Italiano di Tecnologia

\email{atesh.koul@iit.it}
}

