% Generated by roxygen2 (4.0.2): do not edit by hand
\name{shape.matern}
\alias{shape.matern}
\title{Profile likelihood for the shape parameter of the Matern covariance function}
\usage{
shape.matern(formula, coords, data, set.kappa, fixed.rel.nugget = NULL,
  start.par, coverage = NULL, plot.profile = TRUE, messages = TRUE)
}
\arguments{
\item{formula}{an object of class \code{\link{formula}} (or one that can be coerced to that class): a symbolic description of the model to be fitted.}

\item{coords}{an object of class \code{\link{formula}} indicating the geographic coordinates.}

\item{data}{a data frame containing the variables in the model.}

\item{set.kappa}{a vector indicating the set values for evluation of the profile likelihood.}

\item{fixed.rel.nugget}{a value for the relative variance \code{nu2} of the nugget effect, that is then treated as fixed. Default is \code{NULL}.}

\item{start.par}{starting values for the scale parameter \code{phi} and the relative variance of the nugget effect \code{nu2}; if \code{fixed.rel.nugget} is provided, then a starting value for \code{phi} only should be provided.}

\item{coverage}{value between 0 and 1 indicating the coverage of the confidence interval based on the interpolated profile liklelihood for the shape parameter. Default is \code{coverage=NULL} and no confidence interval is then computed.}

\item{plot.profile}{logical; if \code{TRUE} the computed profile-likelihood is plotted together with the interpolating spline.}

\item{messages}{logical; if \code{messages=TRUE} then status messages are printed on the screen (or output device) while the function is running. Default is \code{messages=TRUE}.}
}
\value{
The function returns an object of class 'shape.matern' that is a list with the following components

\code{set.kappa} set of values of the shape parameter used to evaluate the profile-likelihood.

\code{val.kappa} values of the profile likelihood.

If a value for \code{coverage} is specified, the list also contains \code{lower}, \code{upper} and \code{kappa.hat} that correspond to the lower and upper limits of the confidence interval, and the maximum likelihood estimate for the shape parameter, respectively.
}
\description{
This function plots the profile likelihood for the shape parameter of the Matern covariance function used in the linear Gaussian model. It also computes confidence intervals of coverage \code{coverage} by interpolating the profile likelihood with a spline and using the asymptotic distribution of a chi-squared with one degree of freedom.
}
\author{
Emanuele Giorgi \email{e.giorgi@lancaster.ac.uk}

Peter J. Diggle \email{p.diggle@lancaster.ac.uk}
}

