% Generated by roxygen2 (4.0.2): do not edit by hand
\name{continuous.sample}
\alias{continuous.sample}
\title{Spatially continuous sampling}
\usage{
continuous.sample(poly, n, delta, k = 0, rho = NULL)
}
\arguments{
\item{poly}{boundary of a polygon.}

\item{n}{number of events.}

\item{delta}{minimum permissible distance between any two events in preliminary sample.}

\item{k}{number of locations in preliminary sample to be replaced by near neighbours of other preliminary sample locations in final sample (must be between 0 and \code{n/2})}

\item{rho}{maximum distance between close pairs of locations in final sample.}
}
\value{
A matrix of dimension \code{n} by 2 containing event locations.
}
\description{
Draws a sample of spatial locations within a spatially continuous polygonal sampling region.
}
\details{
To draw a sample of size \code{n}  from a spatially continuous region \eqn{A}, with the property that the distance between any two sampled locations is at least \code{delta}, the following algorithm is used.
\itemize{
\item{Step 1.} Set \eqn{i  = 1} and generate a point \eqn{x_{1}}  uniformly distributed on \eqn{A}.
\item{Step 2.} Increase \eqn{i}  by 1, generate a point \eqn{x_{i}}  uniformly distributed on \eqn{A} and calculate the minimum, \eqn{d_{\min}}, of the distances from \eqn{x_{i}} to all \eqn{x_{j}: j < i }.
\item{Step 3.} If \eqn{d_{\min} \ge \delta}, increase \eqn{i}  by 1 and return to step 2 if \eqn{i \le n}, otherwise stop;
\item{Step 4.} If \eqn{d_{\min} < \delta}, return to step 2 without increasing \eqn{i}.
}

\bold{ Sampling close pairs of points.}  For some purposes, it is desirable that a spatial sampling scheme include pairs of closely spaced points. In this case, the above algorithm requires the following additional steps to be taken.
 Let \code{k}  be the required number of close pairs. Choose a value \code{rho}  such that a close pair  of points will be a pair of points separated by a distance of at most \code{rho}.
\itemize{
\item{Step 5.} Set \eqn{j  = 1} and draw a random sample of size 2 from the integers \eqn{1,2,\ldots,n}, say \eqn{(i_{1}; i_{2})};
\item{Step 6.} Replace \eqn{x_{i_{1}}} by \eqn{x_{i_{2}} + u} , where \eqn{u}  is uniformly distributed on the disc with centre \eqn{x_{i_{2}}} and radius \code{rho}, increase \eqn{i} by 1 and return to step 5 if \eqn{i \le k}, otherwise stop.
}
}
\examples{
library(geoR)
data(parana)
poly<-parana$borders
poly<-matrix(c(poly[,1],poly[,2]),dim(poly)[1],2,byrow=FALSE)
set.seed(5871121)

# Generate spatially regular sample
xy.sample<-continuous.sample(poly,100,30)
plot(poly,type="l",xlab="X",ylab="Y")
points(xy.sample,pch=19,cex=0.5)
}
\author{
Emanuele Giorgi \email{e.giorgi@lancaster.ac.uk}

Peter J. Diggle \email{p.diggle@lancaster.ac.uk}
}

