% Generated by roxygen2 (4.0.2): do not edit by hand
\name{Laplace.sampling.lr}
\alias{Laplace.sampling.lr}
\title{Langevin-Hastings MCMC for conditional simulation (low-rank approximation)}
\usage{
Laplace.sampling.lr(mu, sigma2, K, y, units.m, control.mcmc, messages = TRUE,
  plot.correlogram = TRUE)
}
\arguments{
\item{mu}{mean vector of the linear predictor.}

\item{sigma2}{variance of the random effect.}

\item{K}{random effect design matrix, or kernel matrix for the low-rank approximation.}

\item{y}{vector of binomial observations.}

\item{units.m}{vector of binomial denominators.}

\item{control.mcmc}{output from \code{\link{control.mcmc.MCML}}.}

\item{messages}{logical; if \code{messages=TRUE} then status messages are printed on the screen (or output device) while the function is running. Default is \code{messages=TRUE}.}

\item{plot.correlogram}{logical; if \code{plot.correlogram=TRUE} the autocorrelation plot of the conditional simulations is displayed.}
}
\value{
A list with the following components

\code{samples}: a matrix, each row of which corresponds to a sample from the predictive distribution.

\code{h}: vector of the values of the tuning constant at each iteration of the Langevin-Hastings MCMC algorithm.
}
\description{
This function simulates from the conditional distribution of the random effects in a binomial mixed model.
}
\details{
Conditionally on \eqn{Z}, the data \code{y} follow a binomial distribution with probability \eqn{p} and binomial denominators \code{units.m}. Let \eqn{K} denote the random effects design matrix; a logistic link function is used, thus the linear predictor assumes the form \deqn{\log(p/(1-p))=\mu + KZ} where \eqn{\mu} is the mean vector component defined through \code{mu}. The random effect \eqn{Z} has iid components distributed as zero-mean Gaussian variables with variance \code{sigma2}.

\bold{Laplace sampling.} This function generates samples from the distribution of \eqn{Z} given the data \code{y}. Specifically, a Langevin-Hastings algorithm is used to update \eqn{\tilde{Z} = \tilde{\Sigma}^{-1/2}(Z-\tilde{z})} where \eqn{\tilde{\Sigma}} and \eqn{\tilde{z}} are the inverse of the negative Hessian and the mode of the distribution of \eqn{Z} given \code{y}, respectively. At each iteration a new value \eqn{\tilde{z}_{prop}} for \eqn{\tilde{Z}} is proposed from a multivariate Gaussian distribution with mean \deqn{\tilde{z}_{curr}+(h/2)\nabla \log f(\tilde{Z} | y),}
where \eqn{\tilde{z}_{curr}} is the current value for \eqn{\tilde{Z}}, \eqn{h} is a tuning constant and \eqn{\nabla \log f(\tilde{Z} | y)} is the the gradient of the log-density of the distribution of \eqn{\tilde{Z}} given \code{y}. The tuning parameter \eqn{h} is updated according to the following adaptive scheme: the value of \eqn{h} at the \eqn{i}-th iteration, say \eqn{h_{i}}, is given by \deqn{h_{i} = h_{i-1}+c_{1}i^{-c_{2}}(\alpha_{i}-0.547),}
where \eqn{c_{1} > 0} and \eqn{0 < c_{2} < 1} are pre-defined constants, and \eqn{\alpha_{i}} is the acceptance rate at the \eqn{i}-th iteration (\eqn{0.547} is the optimal acceptance rate for a multivariate standard Gaussian distribution).
The starting value for \eqn{h}, and the values for \eqn{c_{1}} and \eqn{c_{2}} can be set through the function \code{\link{control.mcmc.MCML}}.
}
\author{
Emanuele Giorgi \email{e.giorgi@lancaster.ac.uk}

Peter J. Diggle \email{p.diggle@lancaster.ac.uk}
}
\seealso{
\code{\link{control.mcmc.MCML}}.
}

