% Generated by roxygen2 (4.0.2): do not edit by hand
\name{control.prior}
\alias{control.prior}
\title{Priors specification}
\usage{
control.prior(beta.mean, beta.covar, log.prior.sigma2 = NULL,
  log.prior.phi = NULL, log.prior.nugget = NULL, uniform.sigma2 = NULL,
  log.normal.sigma2 = NULL, uniform.phi = NULL, log.normal.phi = NULL,
  uniform.nugget = NULL, log.normal.nugget = NULL)
}
\arguments{
\item{beta.mean}{mean vector of the Gaussian prior for the regression coefficients.}

\item{beta.covar}{covariance matrix of the Gaussian prior for the regression coefficients.}

\item{log.prior.sigma2}{a function corresponding to the log-density of the prior distribution for the variance \code{sigma2} of the Gaussian process. \bold{Warning:} if a low-rank approximation is used, then \code{sigma2} corresponds to the variance of the iid zero-mean Gaussian variables. Default is \code{NULL}.}

\item{log.prior.phi}{a function corresponding to the log-density of the prior distribution for the scale parameter of the Matern correlation function; default is \code{NULL}.}

\item{log.prior.nugget}{optional: a function corresponding to the log-density of the prior distribution for the variance of the nugget effect; default is \code{NULL} with no nugget incorporated in the model; default is \code{NULL}.}

\item{uniform.sigma2}{a vector of length two, corresponding to the lower and upper limit of the uniform prior on \code{sigma2}. Default is \code{NULL}.}

\item{log.normal.sigma2}{a vector of length two, corresponding to the mean and standard deviation of the distribution on the log scale for the log-normal prior on \code{sigma2}. Default is \code{NULL}.}

\item{uniform.phi}{a vector of length two, corresponding to the lower and upper limit of the uniform prior on \code{phi}. Default is \code{NULL}.}

\item{log.normal.phi}{a vector of length two, corresponding to the mean and standard deviation of the distribution on the log scale for the log-normal prior on \code{phi}. Default is \code{NULL}.}

\item{uniform.nugget}{a vector of length two, corresponding to the lower and upper limit of the uniform prior on \code{tau2}. Default is \code{NULL}.}

\item{log.normal.nugget}{a vector of length two, corresponding to the mean and standard deviation of the distribution on the log scale for the log-normal prior on \code{tau2}. Default is \code{NULL}.}
}
\value{
a list corresponding the prior distributions for each model parameter.
}
\description{
This function is used to define priors for the model parameters of a Bayesian geostatistical model.
}
\author{
Emanuele Giorgi \email{e.giorgi@lancaster.ac.uk}

Peter J. Diggle \email{p.diggle@lancaster.ac.uk}
}
\seealso{
See "Priors definition" in the Details section of the \code{\link{binomial.logistic.Bayes}} function.
}

