% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toxAUC.R
\name{toxAUC}
\alias{toxAUC}
\title{Create longitudinal mean score line plots for PRO-CTCAE data with modified
Area Under the Curve (AUC) estimates showing descriptive symptomatic adverse
event burden worsening and improvement from baseline.}
\usage{
toxAUC(
  dsn,
  id_var,
  cycle_var,
  baseline_val,
  arm_var = NA,
  cycle_limit = NA,
  y_limit = 4,
  tab_ymin = NA,
  tab_ymax = NA,
  round_dec = 2,
  overwrite_title = NA
)
}
\arguments{
\item{dsn}{A data.frame object with PRO-CTCAE data}

\item{id_var}{A character string.Name of ID variable differentiating each
PRO-CTCAE survey/participant entered as a quoted string.}

\item{cycle_var}{A character string. Name of variable differentiating one
longitudinal/repeated. PRO-CTCAE survey from another, within an individual
ID.}

\item{baseline_val}{A number indicating the expected baseline cycle/time
point.}

\item{arm_var}{A character string. Name of arm variable differentiating
treatment groups. Must be character or factor class. Overall frequencies
will be reported if no arm/grouping variable is provided. Defaults to
\code{NA}.}

\item{cycle_limit}{A number. Limit the number of cycles to be use to
calculate the AUC metrics up to and including a given cycle number.
All available cycle time points are used if no cycle number is provided.
Defaults to \code{NA}.}

\item{y_limit}{A number. Y axis limit for plots. Defaults to \code{4}.}

\item{tab_ymin}{A number. Y axis coordinate for adjusting the vertical
placement of the AUC table within the figure. Defaults to \code{NA}.}

\item{tab_ymax}{A number. Y axis coordinate for adjusting the vertical
placement of the AUC table within the figure. Defaults to \code{NA}.}

\item{round_dec}{A number. Number of decimal places to be shown within
the AUC table. Defaults to \code{2}.}

\item{overwrite_title}{A character string. Add main title to plots. Defaults
to \code{NA}.}
}
\description{
Data format should be in 'long' format, where each PRO-CTCAE item is a
	  variable/column.
}
\examples{
\dontrun{
AUC=toxAUC(dsn = ProAE::tox_acute[c(1:300, 1101:1400),1:4],
id_var = "id",
cycle_var = "Cycle",
baseline_val = 1)
AUC[[1]]
}
}
