% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toxScores.R
\name{toxScores}
\alias{toxScores}
\title{Re-code PRO-CTCAE text responses, apply a zero-imputation procedures, and
construct PRO-CTCAE composite grades.}
\usage{
toxScores(
  dsn,
  reformat = FALSE,
  impute = FALSE,
  composites = FALSE,
  short_labels = FALSE
)
}
\arguments{
\item{dsn}{A data.frame object with PRO-CTCAE data}

\item{reformat}{Reformat PRO-CTCAE text responses to numeric scores. Defaults
to \code{FALSE}.}

\item{impute}{Apply zero-imputation where appropriate. Defaults to \code{FALSE}.}

\item{composites}{Construct composite grade using available PRO-CTCAE
variables within \code{dsn}. Defaults to \code{FALSE}.}

\item{short_labels}{Add PRO-CTCAE short labels to available PRO-CTCAE
variables within returned object}
}
\value{
A data.frame object.
}
\description{
This function takes in a data frame set with PRO-CTCAE survey text
   fields/responses and returns a data frame with appropriate numerical
   re-coding. This function will accept 1 or up to all 124 PRO-CTCAE survey
   fields. All PRO-CTCAE variable names MUST conform to a pre-specified
   naming structure. PRO-CTCAE variable names are made up of FOUR components:
   1)'PROCTCAE', 2) number [1,2,3, ..., i, ..., 80], 3) 'A', 'B', or 'C'
   component of the i-th PRO-CTCAE field, 4) and 'SCL' (if severity,
   interference, or frequency) or 'IND' (if yes/no variable). Each component
   must be delimited by an underscore (_)
}
\details{
\itemize{
     \item[EX1] Question 1 of PRO-CTCAE should be: PROCTCAE_1A_SCL
     \item[EX2] Question 48 of PRO-CTCAE should be: PROCTCAE_48A_SCL,
     PROCTCAE_48B_SCL, PROCTCAE_48C_SCL
     \item[EX3]Question 73 of PRO-CTCAE should be: PROCTCAE_73A_IND
   }

   This function also constructs PRO-CTCAE composite grades. Composite grade
   variables for respective PRO-CTCAE item groups are created and named as
   PROCTCAE_##_COMP.

   \enumerate{
     \item https://healthcaredelivery.cancer.gov/pro-ctcae/pro-ctcae_english.pdf
     \item Ethan Basch, et al. Development of a Composite Scoring Algorithm
           for the National Cancer Institute's Patient-Reported Outcomes
           version of the Common Terminology Criteria for Adverse Events
           (PRO-CTCAE). ISOQOL 2019
     \item Basch E, et al. Composite Grading Algorithm for the National
           Cancer Institute’s Patient-Reported Outcomes version of the
           Common Terminology Criteria for Adverse Events (PRO-CTCAE).
           Clinical Trials 2020.
   }

	  Data format should be in 'long' format, where each PRO-CTCAE item is a
	  variable/column.
}
\examples{
tox_acute_comp = toxScores(dsn = ProAE::tox_acute, composites = TRUE)
}
