% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/comp.subnet.R
\name{comp.subnet}
\alias{comp.subnet}
\title{Comparing a sub network to the whole one}
\usage{
comp.subnet(x, graph, topology.parameters = TRUE, degree = FALSE,
  cc = FALSE, betweenness = FALSE, eccentricity = FALSE,
  ave.path.len = FALSE, figure.type = 1, method = "utest",
  legendname = c(substitute(x), substitute(graph)))
}
\arguments{
\item{x}{Vertex of the sub network.}

\item{graph}{An igraph object.}

\item{topology.parameters}{Logical value, indicating whether to do basic compariring (if \code{TRUE}) or not (if \code{FALSE}).}

\item{degree}{Logical value, indicating whether to do degree comparing (if \code{TRUE}) or not (if \code{FALSE}).}

\item{cc}{Logical value, indicating whether to do clustering coefficient comparing (if \code{TRUE}) or not (if \code{FALSE}).}

\item{betweenness}{Logical value, indicating whether to do betweenness comparing (if \code{TRUE}) or not (if \code{FALSE}).}

\item{eccentricity}{Logical value, indicating whether to do eccentricity comparing (if \code{TRUE}) or not (if \code{FALSE}).}

\item{ave.path.len}{Logical value, indicating whether to do average path comparing (if \code{TRUE}) or not (if \code{FALSE}).}

\item{figure.type}{Type of the plot. See \code{\link{plot}} for more information.}

\item{method}{Test method, currently only \code{utest} is supported.}

\item{legendname}{Legend name for the plot.}
}
\value{
A list of compared parameters and plot.
}
\description{
Comparing the topological parameters of a sub network and the whole one.
}
\examples{
g<-barabasi.game(100,power=0.8,directed = FALSE)
id<-sample(1:100, 20)
res<-comp.subnet(id,g)
res<-comp.subnet(id,g,topology.parameters=TRUE)
}
\seealso{
\code{\link{comp.rand.subnet}}, \code{\link{net.comparing}}
}

