% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modplug.R
\name{as_modplug_pattern}
\alias{as_modplug_pattern}
\title{Format a ProTracker pattern conform OpenMPT specs}
\usage{
as_modplug_pattern(pattern, ...)
}
\arguments{
\item{pattern}{An object of class \code{pt2pat} to be formatted}

\item{...}{Ignored}
}
\value{
Returns a \code{character} object formatted such that it can be copied into OpenMPT
}
\description{
\href{https://openmpt.org/}{OpenMpt} is a popular modern music tracker. This function allows
you to format a pattern such that it can be pasted directly into OpenMPT.
On Windows you can use \code{writeClipboard()} for this purpose.
}
\examples{
mod    <- pt2_read_mod(pt2_demo())
mp_pat <- as_modplug_pattern(pt2_pattern(mod, 0L))
}
\author{
Pepijn de Vries
}
