% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prob_sup.R
\name{prob_sup}
\alias{prob_sup}
\title{Probabilities of superior performance and stability}
\usage{
prob_sup(extr, int, increase = TRUE, save.df = FALSE, verbose = FALSE)
}
\arguments{
\item{extr}{An object of class \code{extr}, obtained from the \link{extr_outs} function}

\item{int}{A numeric representing the selection intensity
(between 0 and 1)}

\item{increase}{Logical.\code{TRUE} (default) if the selection is for increasing the trait value, \code{FALSE} otherwise.}

\item{save.df}{Logical. Should the data frames be saved in the work directory?
\code{TRUE} for saving, \code{FALSE} (default) otherwise.}

\item{verbose}{A logical value. If \code{TRUE}, the function will indicate the
completed steps. Defaults to \code{FALSE}.}
}
\value{
The function returns an object of class \code{probsup}, which contains two lists,
one with the \code{across}-environments probabilities, and another with the \code{within}-environments probabilities.

The \code{across} list has the following elements:
\itemize{
\item \code{g_hpd}: Highest posterior density (HPD) of the posterior genotypic main effects.
\item \code{perfo}: the probabilities of superior performance.
\item \code{pair_perfo}: the pairwise probabilities of superior performance.
\item \code{stabi}: a list with the probabilities of superior stability. It contains the data frames \code{gl},
\code{gm} (when \code{reg} is not \code{NULL}) and \code{gt} (when \code{year} is not \code{NULL}).
\item \code{pair_stabi}: a list with the pairwise probabilities of superior stability. It contains the data frames \code{gl},
\code{gm} (when \code{reg} is not \code{NULL}) and \code{gt} (when \code{year} is not \code{NULL}).
\item \code{joint_prob}: the joint probabilities of superior performance and stability.
}

The \code{within} list has the following elements:
\itemize{
\item \code{perfo}: a list of data frames containing the probabilities of superior performance
within locations (\code{gl}), regions (\code{gm}) and years (\code{gt}).
\item \code{pair_perfo}: lists with the pairwise probabilities of superior performance
within locations (\code{gl}), regions (\code{gm}) and years (\code{gt}).
}
}
\description{
This function estimates the probabilities of superior performance and stability
across environments, and probabilities of superior performance within environments.
}
\details{
Probabilities provide the risk of recommending a selection candidate for a target
population of environments or for a specific environment. \code{prob_sup}
computes the probabilities of superior performance and the probabilities of superior stability:

\itemize{\item Probability of superior performance}

Let \eqn{\Omega} represent the subset of selected genotypes based on their
performance across environments. A given genotype \eqn{j} will belong to \eqn{\Omega}
if its genotypic marginal value (\eqn{\hat{g}_j}) is high or low enough compared to
its peers. \code{prob_sup} leverages the Monte Carlo discretized sampling
from the posterior distribution to emulate the occurrence of \eqn{S} trials. Then,
the probability of the \eqn{j^{th}} genotype belonging to \eqn{\Omega} is the
ratio of success (\eqn{\hat{g}_j \in \Omega}) events and the total number of sampled events,
as follows:

\deqn{Pr\left(\hat{g}_j \in \Omega \vert y \right) = \frac{1}{S}\sum_{s=1}^S{I\left(\hat{g}_j^{(s)} \in \Omega \vert y\right)}}

where \eqn{S} is the total number of samples \eqn{\left(s = 1, 2, ..., S \right)},
and \eqn{I\left(g_j^{(s)} \in \Omega \vert y\right)} is an indicator variable that can assume
two values: (1) if \eqn{\hat{g}_j^{(s)} \in \Omega} in the \eqn{s^{th}} sample,
and (0) otherwise. \eqn{S} is conditioned to the number of iterations and chains
previously set at \link{bayes_met}.

Similarly, the within-environment probability of superior performance can be applied to
individual environments. Let \eqn{\Omega_k} represent the subset of superior
genotypes in the \eqn{k^{th}} environment, so that the probability of the
\eqn{j^{th} \in \Omega_k} can calculated as follows:

\deqn{Pr\left(\hat{g}_{jk} \in \Omega_k \vert y\right) = \frac{1}{S} \sum_{s=1}^S I\left(\hat{g}_{jk}^{(s)} \in \Omega_k \vert y\right)}

where \eqn{I\left(\hat{g}_{jk}^{(s)} \in \Omega_k \vert y\right)} is an indicator variable
mapping success (1) if \eqn{\hat{g}_{jk}^{(s)}} exists in \eqn{\Omega_k}, and
failure (0) otherwise, and \eqn{\hat{g}_{jk}^{(s)} = \hat{g}_j^{(s)} + \widehat{ge}_{jk}^{(s)}}.
Note that when computing within-environment probabilities, we are accounting for
the interaction of the \eqn{j^{th}} genotype with the \eqn{k^{th}}
environment.

The pairwise probabilities of superior performance can also be calculated across
or within environments. This metric assesses the probability of the \eqn{j^{th}}
genotype being superior to another experimental genotype or a commercial check.
The calculations are as follows, across and within environments, respectively:

\deqn{Pr\left(\hat{g}_{j} > \hat{g}_{j^\prime} \vert y\right) = \frac{1}{S} \sum_{s=1}^S I\left(\hat{g}_{j}^{(s)} > \hat{g}_{j^\prime}^{(s)} \vert y\right)}

or

\deqn{Pr\left(\hat{g}_{jk} > \hat{g}_{j^\prime k} \vert y\right) = \frac{1}{S} \sum_{s=1}^S I\left(\hat{g}_{jk}^{(s)} > \hat{g}_{j^\prime k}^{(s)} \vert y\right)}

These equations are set for when the selection direction is positive. If
\code{increase = FALSE}, \eqn{>} is simply switched by \eqn{<}.

\itemize{\item Probability of superior stability}

This probability makes a direct analogy with the
method of Shukla (1972): a stable genotype is the one that has a low
genotype-by-environment interaction variance \eqn{[var(\widehat{ge})]}.
Using the same probability principles previously described, the probability
of superior stability is given as follows:

\deqn{Pr \left[var \left(\widehat{ge}_{jk}\right) \in \Omega \vert y \right] = \frac{1}{S} \sum_{s=1}^S I\left[var \left(\widehat{ge}_{jk}^{(s)} \right) \in \Omega \vert y \right]}

where \eqn{I\left[var \left(\widehat{ge}_{jk}^{(s)} \right) \in \Omega \vert y \right]} indicates if
\eqn{var\left(\widehat{ge}_{jk}^{(s)}\right)} exists in \eqn{\Omega} (1) or not (0).
Pairwise probabilities of superior stability are also possible in this context:

\deqn{Pr \left[var \left(\widehat{ge}_{jk} \right) < var\left(\widehat{ge}_{j^\prime k} \right) \vert y \right] = \frac{1}{S} \sum_{s=1}^S I \left[var \left(\widehat{ge}_{jk} \right)^{(s)} < var \left(\widehat{ge}_{j^\prime k} \right)^{(s)} \vert y \right]}

Note that \eqn{j} will be superior to \eqn{j^\prime} if it has a \strong{lower}
variance of the genotype-by-environment interaction effect. This is true regardless
if \code{increase} is set to \code{TRUE} or \code{FALSE}.

The joint probability independent events is the product of the individual probabilities.
The estimated genotypic main effects and the variances of GEI effects are independent
by design, thus the joint probability of superior performance and stability as follows:

\deqn{Pr \left[\hat{g}_j \in \Omega \cap var \left(\widehat{ge}_{jk} \right) \in \Omega \right] = Pr \left(\hat{g}_j \in \Omega \right) \times Pr \left[var \left(\widehat{ge}_{jk} \right) \in \Omega \right]}

The estimation of these probabilities are strictly related to some key questions that
constantly arises in plant breeding:
\itemize{
\item \strong{What is the risk of recommending a selection candidate for a target population of environments?}
\item \strong{What is the probability of a given selection candidate having good performance if
recommended to a target population of environments? And for a specific environment?}
\item \strong{What is the probability of a given selection candidate having better performance
than a cultivar check in the target population of environments? And in specific environments?}
\item \strong{How probable is it that a given selection candidate performs similarly across environments?}
\item \strong{What are the chances that a given selection candidate is more stable
than a cultivar check in the target population of environments?}
\item \strong{What is the probability that a given selection candidate having a
superior and invariable performance across environments?}
}

More details about the usage of \code{prob_sup}, as well as the other function of
the \code{ProbBreed} package can be found at \url{https://saulo-chaves.github.io/ProbBreed_site/}.
}
\examples{
\donttest{
mod = bayes_met(data = soy,
                gen = "Gen",
                loc = "Loc",
                repl = NULL,
                year = NULL,
                reg = NULL,
                res.het = TRUE,
                trait = 'Y',
                iter = 6000, cores = 4, chains = 4)

outs = extr_outs(model = mod,
                 probs = c(0.05, 0.95),
                 verbose = TRUE)

results = prob_sup(extr = outs,
                   int = .2,
                   increase = TRUE,
                   save.df = FALSE,
                   verbose = FALSE)
}

}
\references{
Dias, K. O. G, Santos J. P. R., Krause, M. D., Piepho H. -P., Guimarães, L. J. M.,
Pastina, M. M., and Garcia, A. A. F. (2022). Leveraging probability concepts
for cultivar recommendation in multi-environment trials. \emph{Theoretical and
Applied Genetics}, 133(2):443-455. \doi{10.1007/s00122-022-04041-y}

Shukla, G. K. (1972) Some statistical aspects of partioning genotype environmental
componentes of variability. \emph{Heredity}, 29:237-245. \doi{10.1038/hdy.1972.87}
}
\seealso{
\link{plot.probsup}
}
