% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.permutedReserve.R
\name{print.permutedReserve}
\alias{print.permutedReserve}
\title{Print objects of the S3 class \code{permutedReserve}}
\usage{
\method{print}{permutedReserve}(x, ...)
}
\arguments{
\item{x}{an object of the class \code{permutedReserve} resulting from a call
of the functions \code{permuteReserve()}}

\item{...}{further arguments passed to \code{print}}
}
\value{
Displays information about the estimated reserve (by one of the
estimation algorithms -- PARALLAX, REACT, or MACRAME) and the overall reserve
distribution resulting from a call of the \code{permuteReserve()} function
}
\description{
Function to organize and print the output provided by the permutation bootstrap
method implemented in the function  \code{permuteReserve()}
}
\examples{
## reserve point prediction by the PARALLAX method
output <- parallelReserve(CameronMutual)

## reserve distribution prediction by the permutation bootstrap
x <- permuteReserve(output, B = 100)

## summary of the results
print(x) 

}
\seealso{
\code{\link[=permuteReserve]{permuteReserve()}}
}
