% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getData.R
\name{getData}
\alias{getData}
\title{A function to extract data}
\usage{
getData(
  dataset,
  site = NULL,
  location = NULL,
  forcingDataset = NULL,
  forcingCondition = NULL,
  species = NULL,
  variables = NULL,
  period = NULL,
  collapse = TRUE,
  quality = NULL,
  decreasing = TRUE
)
}
\arguments{
\item{dataset}{a character string providing the name of a dataset.}

\item{site}{a character string providing the name of a site.}

\item{location}{deprecated argument. Please use site instead.}

\item{forcingDataset}{a character string providing the name of a forcingDataset.
Only relevant for ISIMIP datasets.}

\item{forcingCondition}{a character string providing the name of a forcingCondition.
Only relevant for ISIMIP datasets.}

\item{species}{a character string providing the species name or species id.}

\item{variables}{a character array holding the variables to be plotted. Default  is all variables.}

\item{period}{a character array with either start or start and end of the subset.
It must have the format "YYYY-MM-DD", or c("YYYY-MM-DD", "YYYY-MM-DD").}

\item{collapse}{a boolean indicating whether the returned data should be a
single data frame (TRUE) or a list of data frames (FALSE). Relevant when downloading SOIL and ISIMIP datasets.}

\item{quality}{a number indicating the quality threshold to be used. Default is none.}

\item{decreasing}{a boolean indicating whether the quality threshold should be applied up- or downwards.}
}
\value{
a data frame or a list of data frames, depending on collapse.
}
\description{
A function to extract datasets for a site
from the PROFOUND database.
}
\details{
When using quality, please be aware that the threshold value is included
in the returned data. Thresholding works by removing data values that are greater
 (decreasing = TRUE) or smaller (decreasing = FALSE) than the given value.
 The quality parameter is only relevant for datasets that have quality flags. These are
ATMOSPHERICHEATCONDUCTION, SOILTS, FLUX, METEOROLOGICAL, and CLIMATE LOCAL. Please
check the metadata of each dataset before using this parameter.
}
\note{
To report errors in the package or the data, please use the issue tracker
in the GitHub repository of ProfoundData \url{https://github.com/COST-FP1304-PROFOUND/ProfoundData}
}
\examples{
# example requires that a sql DB is registered via setDB(dbfile)
# when run without a registered DB, you will get a file query (depending on OS)

\dontrun{
# Get SITES data
sites <- getData(dataset =  "SITES")

# Get SITES data of a specific site
site <- getData(dataset =  "SITES", site = "soro")

# Get SITEDESCRIPTION
sites <- getData(dataset =  "SITEDESCRIPTION")

# Get SITEDESCRIPTION of a specific site
site <- getData(dataset =  "SITEDESCRIPTION", site = "lebray")

# Get any dataset for a site
data <- getData(dataset =  "CLIMATE_LOCAL", site = "soro")

# Get ISIMIP datasets as a list with data frames
data <- getData(dataset ="CLIMATE_ISIMIP2A", site = "soro", collapse = TRUE)
data <- getData(dataset ="CLIMATE_ISIMIP2B", site = "soro", collapse = TRUE)
data <- getData(dataset ="NDEPOSITION_ISIMIP2B", site = "soro", collapse = TRUE)

# Get ISIMIP datasets as an unique data frame
data <- getData(dataset ="CLIMATE_ISIMIP2A", site = "soro", collapse = FALSE)
data <- getData(dataset ="CLIMATE_ISIMIP2B", site = "soro", collapse = FALSE)
data <- getData(dataset ="NDEPOSITION_ISIMIP2B", site = "soro", collapse = FALSE)

# Get SOIL data. Collapse FALSE is recommended.
data <- getData(dataset ="SOIL", site = "soro", collapse = FALSE)

# Get specific forcing datasets and/or forcing conditions
data <- getData(dataset ="CLIMATE_ISIMIP2B", site ="soro",
                 forcingDataset="GFDLESM2M", forcingCondition ="rcp2p6")
# which is equivalent to
data <- getData(dataset ="CLIMATE_ISIMIP2B_GFDLESM2M_rcp2p6", site ="soro")

# Specify variables
data <- getData(dataset ="CLIMATE_ISIMIP2B", site ="soro",
                forcingDataset="GFDLESM2M", forcingCondition ="rcp2p6",
                variables = "p_mm")
data <- getData(dataset ="CLIMATE_ISIMIP2B", site ="soro",
                forcingDataset="GFDLESM2M", forcingCondition ="rcp2p6",
                variables = c("tmax_degC","p_mm"))

# Specify species
data <- getData(dataset ="TREE", site ="hyytiala", species = "Pinus sylvestris")
data <- getData(dataset ="TREE", site ="hyytiala", species = "pisy")
data <- getData(dataset ="STAND", site ="hyytiala", species = "Picea abies")
data <- getData(dataset ="STAND", site ="hyytiala", species = "piab")

# Specify period
data <- getData(dataset ="CLIMATE_ISIMIP2B", site ="soro",
                forcingDataset="GFDLESM2M", forcingCondition ="rcp2p6",
                period = c("2006-01-01","2006-12-31"))

# Specify quality
data <- getData(dataset = "CLIMATE_LOCAL", site = "soro",
                quality = 1, decreasing = FALSE)
data <- getData(dataset = "FLUX", site = "soro",
                quality = 0, decreasing = TRUE)
}
}
\keyword{ProfoundData}
