% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{get_mut_status}
\alias{get_mut_status}
\title{Converts MAF file into mutation matrix.}
\usage{
get_mut_status(mutvariant, nonsynonymous = TRUE)
}
\arguments{
\item{mutvariant}{A nx3 data frame of patients' somatic mutation data,the first line is gene symbol,the second line is sample ID and the third line is mutation classification.}

\item{nonsynonymous}{Logical, tell if extract the non-synonymous somatic mutations (nonsense mutation, missense mutation, frame-shif indels, splice site, nonstop mutation, translation start site, inframe indels).}
}
\value{
A binary mutations matrix, in which 1 represents that a particular gene has mutated in a particular sample, and 0 represents that gene has no mutation in a particular sample.
}
\description{
The function 'get_mut_status' uses to convert MAF file into mutation matrix.
}
\examples{
\donttest{maf<-system.file("extdata","maffile.maf",package = "ProgModule")
maf_data<-read.delim(maf)
mutvariant<-maf_data[,c("Hugo_Symbol","Tumor_Sample_Barcode","Variant_Classification")]
#perform the function `get_mut_status`.
mut_status.example<-get_mut_status(mutvariant,nonsynonymous = TRUE)}
}
