% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{get_oncoplots}
\alias{get_oncoplots}
\title{Draw a waterfall plot of mutated genes involved in the module}
\usage{
get_oncoplots(
  maf,
  genes,
  removeNonMutated = TRUE,
  top = 20,
  minMut = NULL,
  altered = FALSE,
  drawRowBar = TRUE,
  drawColBar = TRUE,
  leftBarData = NULL,
  leftBarLims = NULL,
  rightBarData = NULL,
  rightBarLims = NULL,
  topBarData = NULL,
  logColBar = FALSE,
  includeColBarCN = TRUE,
  clinicalFeatures = NULL,
  annotationColor = NULL,
  annotationDat = NULL,
  pathways = NULL,
  path_order = NULL,
  selectedPathways = NULL,
  pwLineCol = "#535c68",
  pwLineWd = 1,
  draw_titv = FALSE,
  titv_col = NULL,
  showTumorSampleBarcodes = FALSE,
  barcode_mar = 4,
  barcodeSrt = 90,
  gene_mar = 5,
  anno_height = 1,
  legend_height = 4,
  sortByAnnotation = FALSE,
  groupAnnotationBySize = TRUE,
  annotationOrder = NULL,
  sortByMutation = FALSE,
  keepGeneOrder = FALSE,
  GeneOrderSort = TRUE,
  sampleOrder = NULL,
  additionalFeature = NULL,
  additionalFeaturePch = 20,
  additionalFeatureCol = "gray70",
  additionalFeatureCex = 0.9,
  genesToIgnore = NULL,
  fill = TRUE,
  cohortSize = NULL,
  colors = NULL,
  cBioPortal = FALSE,
  bgCol = "#CCCCCC",
  borderCol = "white",
  annoBorderCol = NA,
  numericAnnoCol = NULL,
  drawBox = FALSE,
  fontSize = 0.8,
  SampleNamefontSize = 1,
  titleFontSize = 1.5,
  legendFontSize = 1.2,
  annotationFontSize = 1.2,
  sepwd_genes = 0.5,
  sepwd_samples = 0.25,
  writeMatrix = FALSE,
  colbar_pathway = FALSE,
  showTitle = TRUE,
  titleText = NULL,
  showPct = TRUE
)
}
\arguments{
\item{maf}{The patients' somatic mutation data, which in MAF format.}

\item{genes}{Modular gene set from final_candidate_module,generated by `get_final_candidate_module`.}

\item{removeNonMutated, top, minMut, altered, drawRowBar, drawColBar, leftBarData, leftBarLims, rightBarData, rightBarLims, topBarData, logColBar, includeColBarCN, clinicalFeatures, annotationColor, annotationDat, pathways, path_order, selectedPathways, pwLineCol, pwLineWd, draw_titv, titv_col, showTumorSampleBarcodes, barcode_mar, barcodeSrt, gene_mar, anno_height, legend_height, sortByAnnotation, groupAnnotationBySize, annotationOrder, sortByMutation, keepGeneOrder, GeneOrderSort, sampleOrder, additionalFeature, additionalFeaturePch, additionalFeatureCol, additionalFeatureCex, genesToIgnore, fill, cohortSize, colors, cBioPortal, bgCol, borderCol, annoBorderCol, numericAnnoCol, drawBox, fontSize, SampleNamefontSize, titleFontSize, legendFontSize, annotationFontSize, sepwd_genes, sepwd_samples, writeMatrix, colbar_pathway, showTitle, titleText, showPct}{see \code{\link[maftools]{oncoplot}}}
}
\value{
No return value
}
\description{
Load the data in MAF format and draws a waterfall plot of mutated genes involved in the module.
}
\examples{
#load the data.
maffile<-system.file("extdata","maffile.maf",package="ProgModule")
data(final_candidate_module)
#draw an oncoplot
get_oncoplots(maf=maffile,genes=final_candidate_module[[1]])
}
