% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_mce.R
\name{mce}
\alias{mce}
\title{Build a precedence matrix}
\usage{
mce(duration, minimum.durations, prec1and2 = matrix(0),
  prec3and4 = matrix(0), activities.costs, duration.project = NULL)
}
\arguments{
\item{duration}{Vector with the duration for each activity.}

\item{minimum.durations}{Vector with the Minimum duration allowed for each activity.}

\item{prec1and2}{A matrix indicating the order of precedence type 1 and 2 between the activities (Default=matrix(0)). If value \eqn{(i,j)=1} then activity \eqn{i} precedes type \eqn{1} to \eqn{j}, and if \eqn{(i,j)=2} then activity \eqn{i} precedes type \eqn{2} to \eqn{j}. Cycles cannot exist in a project,  i.e. if an activity \eqn{i} precedes \eqn{j} then \eqn{j} cannot precede \eqn{i}.}

\item{prec3and4}{A matrix indicating the order of precedence type 3 and 4 between the activities (Default=matrix(0)). If value \eqn{(i,j)=3} then activity \eqn{i} precedes type \eqn{3} to \eqn{j}, and if \eqn{(i,j)=4} then activity \eqn{i} precedes type \eqn{4} to \eqn{j}. Cycles cannot exist in a project,  i.e. if an activity \eqn{i} precedes \eqn{j} then \eqn{j} cannot precede \eqn{i}.}

\item{activities.costs}{Vector indicating the cost of accelerating a unit of time the duration of each activity.}

\item{duration.project}{numerical value indicating the minimum time sought in the project (Default=NULL).}
}
\value{
A solution matrices.
}
\description{
This function calculates the costs per activity to accelerate the project.
}
\details{
The MCE method (Minimal Cost Expediting) tries to speed up the project at minimum cost. It considers that the duration of some project activities could be reduced by increasing the resources allocated to them (and thus increasing their implementation costs).
}
\examples{

duration<-c(5,4,5,2,2)
minimum.durations<-c(3,2,3,1,1)
activities.costs<-c(1,1,1,1,1)
prec1and2<-matrix(c(0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0),nrow=5,ncol=5,byrow=TRUE)
duration.project<-7

mce(duration,minimum.durations,prec1and2,prec3and4=matrix(0),activities.costs,duration.project)
}
\references{
\describe{
  \item{}{Kelley Jr, J. E. (1961). Critical-path planning and scheduling: Mathematical basis. Operations research, 9(3), 296-320.}
}
}
