% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pug_view.R
\name{get_pug_view}
\alias{get_pug_view}
\title{Retrieve PUG View Data from PubChem}
\usage{
get_pug_view(
  annotation = NULL,
  identifier = NULL,
  domain = "compound",
  output = "JSON",
  heading = NULL,
  headingType = NULL,
  page = NULL,
  qrSize = "short",
  save = FALSE
)
}
\arguments{
\item{annotation}{A character string specifying the type of annotation to retrieve.}

\item{identifier}{A single identifier for the query, either numeric or character.}

\item{domain}{A character string specifying the domain for the request. Default is 'compound'.}

\item{output}{A character string specifying the output format. Possible values are 'JSON', 'XML', and 'SVG'. Default is 'JSON'.}

\item{heading}{An optional character string for specifying a heading in the request.}

\item{headingType}{An optional character string for specifying a heading type in the request.}

\item{page}{An optional character string for specifying a page number in the request.}

\item{qrSize}{A character string specifying the size of the QR code. Possible values are 'short' and 'long'. Default is 'short'.}

\item{save}{A logical value indicating whether to save the output. Default is FALSE.}
}
\value{
Depending on the output format, this function returns different types of content:
        JSON or JSONP format returns parsed JSON content.
        SVG format returns an image object.
        For QR codes, it returns an image object or saves a PNG file.
}
\description{
This function sends a request to the PubChem PUG View API to retrieve various types of data
for a given identifier. It supports fetching annotations, QR codes, and more, with options
for different output formats including JSON and SVG.
}
\examples{
  get_pug_view(identifier = "2244", annotation = "linkout", domain = "compound")

}
