% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_sdf.R
\name{get_sdf}
\alias{get_sdf}
\title{Retrieve/Save SDF Data from PubChem}
\usage{
get_sdf(
  identifier,
  namespace = "cid",
  domain = "compound",
  operation = NULL,
  searchtype = NULL,
  path = NULL,
  file_name = NULL,
  options = NULL
)
}
\arguments{
\item{identifier}{A character or numeric value specifying the identifier for the request.}

\item{namespace}{A character string specifying the namespace for the request. Default is 'cid'.}

\item{domain}{A character string specifying the domain for the request. Default is 'compound'.}

\item{operation}{An optional character string specifying the operation for the request.}

\item{searchtype}{An optional character string specifying the search type.}

\item{path}{A string indicating the path to the folder where the SDF files will be saved. Default is NULL (i.e., saves the file into a temporary folder).}

\item{file_name}{A string. File name for the downloaded SDF file. If NULL, "file" is used as the file name. Default is NULL.}

\item{options}{Additional parameters to be passed to the request.}
}
\value{
NULL. The function saves the retrieved data as an SDF file in the current working directory and prints a
message indicating the file's location.
}
\description{
This function sends a request to PubChem to retrieve data in SDF format based on the specified parameters.
It then saves the retrieved data as an SDF file in the current working directory (or into the system-specific temporary folder).
}
\examples{
get_sdf(
  identifier = "aspirin",
  namespace = "name",
  path = NULL
)

}
