% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_data.R
\name{merge_data}
\alias{merge_data}
\title{Merging the three financial datasets}
\usage{
merge_data(data_RENDIS, data_OBDAP, data_OC)
}
\arguments{
\item{data_RENDIS}{Dataset of class 'data.frame'. Specify the dataset obtained from the ReNDiS database by the \code{get_data_RENDIS} function.}

\item{data_OBDAP}{Dataset of class 'data.frame'. Specify the dataset obtained from the OpenBDAP database by the \code{get_data_OBDAP} function.}

\item{data_OC}{Dataset of class 'data.frame'. Specify the dataset obtained from the OpenCoesione database by the \code{get_data_region_OC} or \code{get_data_theme_OC} function.}
}
\value{
Object of class \code{data.frame} showing 28 variables:

Descriptive Variables:
\itemize{
\item{CUP (\code{character})}
\item{Intervention (\code{character})}
\item{Source (\code{character})}
}

Financial Variables:
\itemize{
\item{State Funding (\code{numeric})}
\item{EU Funding (\code{numeric})}
\item{Local Authorities Funding (\code{numeric})}
\item{Private Funding (\code{numeric})}
\item{Other Funding (\code{numeric})}
\item{Finance (\code{numeric})}
}

Geographical References:
\itemize{
\item{DEN_REGION (\code{character})}
\item{DEN_PROVINCE (\code{character})}
\item{DEN_MUNICIPALITY (\code{character})}
\item{COD_REGION (\code{character})}
\item{COD_PROVINCE (\code{character})}
\item{COD_MUNICIPALITY (\code{character})}
\item{geom (\code{character})}
}

Legislative process main steps:
\itemize{
\item{Feasibility Study Starting Date (\code{character})}
\item{Feasibility Study Ending Date (\code{character})}
\item{Preliminary Design Starting Date (\code{character})}
\item{Preliminary Design Ending Date (\code{character})}
\item{Definitive Design Starting Date (\code{character})}
\item{Definitive Design Ending Date (\code{character})}
\item{Executive Design Starting Date (\code{character})}
\item{Executive Design Ending Date (\code{character})}
\item{Works Execution Starting Date (\code{character})}
\item{Works Execution Ending Date  (\code{character})}
\item{Conclusion Starting Date (\code{character})}
\item{Conclusion Ending Date (\code{character})}
}
}
\description{
Function to merge the three financial datasets from the three different platforms to obtain a complete dataset to have a comprhensive overview of the investements.
}
\examples{
data(OCpoint)
data(OBDAPpoint)
data(RENDISpoint)
data_all <- merge_data(RENDISpoint, OBDAPpoint, OCpoint)

}
\author{
Lorena Ricciotti
}
