% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svalue.R
\name{pubbias_svalue}
\alias{pubbias_svalue}
\alias{svalue}
\title{Severity of publication bias needed to "explain away" results}
\usage{
pubbias_svalue(
  yi,
  vi,
  sei,
  cluster = 1:length(yi),
  q = 0,
  model_type = "robust",
  favor_positive = TRUE,
  alpha_select = 0.05,
  ci_level = 0.95,
  small = TRUE,
  selection_ratio_max = 200,
  return_worst_meta = FALSE
)

svalue(
  yi,
  vi,
  q,
  clustervar = 1:length(yi),
  model,
  alpha.select = 0.05,
  eta.grid.hi = 200,
  favor.positive,
  CI.level = 0.95,
  small = TRUE,
  return.worst.meta = FALSE
)
}
\arguments{
\item{yi}{A vector of point estimates to be meta-analyzed.}

\item{vi}{A vector of estimated variances (i.e., squared standard errors) for
the point estimates.}

\item{sei}{A vector of estimated standard errors for the point estimates.
(Only one of \code{vi} or \code{sei} needs to be specified).}

\item{cluster}{Vector of the same length as the number of rows in the data,
indicating which cluster each study should be considered part of (defaults
to treating studies as independent; i.e., each study is in its own cluster).}

\item{q}{The attenuated value to which to shift the point estimate or CI.
Should be specified on the same scale as \code{yi} (e.g., if
\code{yi} is on the log-RR scale, then \code{q} should be as well).}

\item{model_type}{"fixed" for fixed-effects (a.k.a. "common-effect") or
"robust" for robust random-effects.}

\item{favor_positive}{\code{TRUE} if publication bias are
assumed to favor significant positive estimates; \code{FALSE} if assumed to
favor significant negative estimates.}

\item{alpha_select}{Alpha level at which an estimate's probability of being
favored by publication bias is assumed to change (i.e.,
the threshold at which study investigators, journal editors, etc., consider
an estimate to be significant).}

\item{ci_level}{Confidence interval level (as proportion) for the corrected
point estimate. (The alpha level for inference on the corrected point
estimate will be calculated from \code{ci_level}.)}

\item{small}{Should inference allow for a small meta-analysis? We recommend
always using \code{TRUE}.}

\item{selection_ratio_max}{The largest value of \code{selection_ratio} that should
be included in the grid search. This argument is only needed when
\code{model_type = "robust"}.}

\item{return_worst_meta}{Should the worst-case meta-analysis of only the
nonaffirmative studies be returned?}

\item{clustervar}{(deprecated) see cluster}

\item{model}{(deprecated) see model_type}

\item{alpha.select}{(deprecated) see alpha_select}

\item{eta.grid.hi}{(deprecated) see selection_ratio_max}

\item{favor.positive}{(deprecated) see favor_positive}

\item{CI.level}{(deprecated) see ci_level}

\item{return.worst.meta}{(deprecated) see return_worst_meta}
}
\value{
An object of class \code{\link[metabias:metabias-class]{metabias::metabias()}}, a list containing:
\describe{
\item{data}{A tibble with one row per study and the columns
\code{yi}, \code{yif}, \code{vi}, \code{affirm}, \code{cluster}.}
\item{values}{A list with the elements \code{selection_ratio}, \code{selection_tails}, \code{model_type}, \code{favor_positive}, \code{alpha_select}, \code{ci_level}, \code{small}, \code{k}, \code{k_affirmative}, \code{k_nonaffirmative}.}
\item{stats}{A tibble with the columns \code{model}, \code{estimate}, \code{se}, \code{ci_lower}, \code{ci_upper}, \code{p_value}.
\code{sval_est} represents the amount of publication bias required
to attenuate the pooled point estimate to \code{q}; \code{sval_ci}
represents the amount of publication bias required to
attenuate the confidence interval limit of the pooled point
estimate to \code{q}.}
\item{fit}{A list of fitted models, if any.}
}
}
\description{
Estimates the S-value, defined as the severity of publication bias (i.e., the
ratio by which affirmative studies are more likely to be published than
nonaffirmative studies) that would be required to shift the pooled point
estimate or its confidence interval limit to the value \code{q}.
}
\details{
To illustrate interpretation of the S-value, if the S-value for the
point estimate is 30 with \code{q=0}, this indicates that affirmative studies
(i.e., those with a "statistically significant" and positive estimate)
would need to be 30-fold more likely to be published than nonaffirmative
studies (i.e., those with a "nonsignificant" or negative estimate) to
attenuate the pooled point estimate to \code{q}.

If \code{favor_positive = FALSE}, such that publication bias is assumed to favor
negative rather than positive estimates, the signs of \code{yi} will be reversed
prior to performing analyses. The returned number of affirmative and
nonaffirmative studies will reflect the recoded signs.

If \code{return_worst_meta = TRUE}, also returns the worst-case meta-analysis of
only the nonaffirmative studies. If \code{model_type = "fixed"}, the worst-case
meta-analysis is fit by \code{metafor::rma.uni()}. If \code{model_type = "robust"},
it is fit by \code{robumeta::robu()}. Note that in the latter case, custom
inverse-variance weights are used, which are the inverse of the sum of the
study's variance and a heterogeneity estimate from a naive random-effects
meta-analysis (Mathur & VanderWeele, 2020). This is done for consistency
with the results of \code{pubbias_meta()}, which is used to determine \code{sval_est}
and \code{sval_ci}. Therefore, the worst-case meta-analysis results may differ
slightly from what you would obtain if you simply fit \code{robumeta::robu()} on
the nonaffirmative studies with the default weights.
}
\examples{
# calculate effect sizes from example dataset in metafor
require(metafor)
dat <- metafor::escalc(measure = "RR", ai = tpos, bi = tneg, ci = cpos,
                       di = cneg, data = dat.bcg)

##### Fixed-Effects Specification #####
# S-values and worst-case meta-analysis under fixed-effects specification
svals_fixed_0 <- pubbias_svalue(yi = dat$yi,
                                vi = dat$vi,
                                q = 0,
                                model_type = "fixed",
                                favor_positive = FALSE)

# publication bias required to shift point estimate to 0
svals_fixed_0$stats$sval_est

# and to shift CI to include 0
svals_fixed_0$stats$sval_ci

# now try shifting to a nonzero value (RR = 0.90)
svals_fixed_q <- pubbias_svalue(yi = dat$yi,
                                vi = dat$vi,
                                q = log(.9),
                                model_type = "fixed",
                                favor_positive = FALSE)

# publication bias required to shift point estimate to RR = 0.90
svals_fixed_q$stats$sval_est

# and to shift CI to RR = 0.90
svals_fixed_q$stats$sval_ci

##### Robust Clustered Specification #####
pubbias_svalue(yi = dat$yi,
               vi = dat$vi,
               q = 0,
               model_type = "robust",
               favor_positive = FALSE)
}
\references{
\insertRef{mathur2020}{metabias}
}
\keyword{internal}
