% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ys_VHX_BPD}
\alias{ys_VHX_BPD}
\title{Example \emph{Plasmodium vivax} data}
\format{
A list of 217 study participants; for each study participant, a list of one or more
episodes; for each episode, a list of three or more microsatellite markers;
for each marker, a vector of observed alleles (repeat lengths). For example:
\describe{
\item{BPD_103}{Study participant identifier: study participant 103 in the BPD trial}
\item{BPD_103_1}{Episode identifier: episode one of study participant 103 in the BPD trial}
\item{PV.3.27}{Marker identifier: \emph{P. vivax} 3.27}
\item{18}{Allele identifier: 18 repeat lengths}
}
}
\source{
\itemize{
\item \url{https://zenodo.org/records/3368828}
\item \url{https://github.com/aimeertaylor/Pv3Rs/blob/main/data-raw/ys_VHX_BPD.R}
}
}
\usage{
ys_VHX_BPD
}
\description{
Previously-published microsatellite data on \emph{P. vivax} parasites
extracted from study participants enrolled in the Best Primaquine Dose (BPD) and Vivax
History (VHX) trials; see
Taylor & Watson et al. 2019 (\doi{doi:10.1038/s41467-019-13412-x})
for more details of the genetic data; for more details of the VHX and BPD trials, see
Chu et al. 2018a (\doi{doi:10.1093/cid/ciy319}) and
Chu et al. 2018b (\doi{doi:10.1093/cid/ciy735}).
}
\keyword{datasets}
