% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{list_trials}
\alias{list_trials}
\title{Get the list of trials in the current active breeding program}
\usage{
list_trials(year = NULL)
}
\arguments{
\item{year}{the starting year to filter the list of trials (optional, default is NULL)}
}
\value{
a list of trials names
}
\description{
This function will retrieve the trials list from the current active breeding 
program as configured in the internal state object using `set_program()` 
function.
}
\examples{
if(interactive()){
# config your BMS connection
set_qbms_config("https://www.bms-uat-test.net/ibpworkbench")

# login using your BMS account (interactive mode)
# you can pass BMS username and password as parameters (batch mode)
login_bms()

set_crop("maize")

# select a breeding program by name
set_program("MC Maize")

# list all studies/trials in the selected program
list_trials()

# filter listed studies/trials by year
list_trials(2020)
}
}
\seealso{
\code{\link{login_bms}}, \code{\link{set_crop}}, \code{\link{set_program}}
}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}
}
