% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{set_study}
\alias{set_study}
\title{Set the current active study by location name}
\usage{
set_study(study_name)
}
\arguments{
\item{study_name}{the name of the study}
}
\value{
no return value
}
\description{
This function will update the current active study in the internal state 
object using the studyDbId retrieved from BMS which is associated to the 
given study_name parameter.
}
\examples{
if(interactive()){
# config your BMS connection
set_qbms_config("https://www.bms-uat-test.net/ibpworkbench")

# login using your BMS account (interactive mode)
# you can pass BMS username and password as parameters (batch mode)
login_bms()

set_crop("maize")

# select a breeding program by name
set_program("MC Maize")

# select a specific study/trial by name
set_trial("2018 PVT")

# select a specific environment/location dataset
set_study("2018 PVT Environment Number 1")
}
}
\seealso{
\code{\link{login_bms}}, \code{\link{set_crop}}, \code{\link{set_program}}, \code{\link{set_trial}}, \code{\link{list_studies}}
}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}
}
